/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private int[] referencedColumns;

    public int[] getReferencedColumnPositions() {
        return this.referencedColumns;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.referencedColumns = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.referencedColumns[n2] = objectInput.readInt();
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.referencedColumns.length);
        int n = 0;
        while (n < this.referencedColumns.length) {
            objectOutput.writeInt(this.referencedColumns[n]);
            ++n;
        }
    }

    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('(');
        int n = 0;
        while (n < this.referencedColumns.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(this.referencedColumns[n]));
            ++n;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public ReferencedColumnsDescriptorImpl(int[] nArray) {
        this.referencedColumns = nArray;
    }

    public ReferencedColumnsDescriptorImpl() {
    }
}

