/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.MethodAliasInfo;
import org.apache.derby.iapi.services.io.ArrayUtil;

public class RoutineAliasInfo
extends MethodAliasInfo {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";
    private static final String[] SQL_CONTROL = new String[]{"MODIFIES SQL DATA", "READS SQL DATA", "CONTAINS SQL", "NO SQL"};
    public static final short MODIFIES_SQL_DATA = 0;
    public static final short READS_SQL_DATA = 1;
    public static final short CONTAINS_SQL = 2;
    public static final short NO_SQL = 3;
    public static final short PS_JAVA = 0;
    private int parameterCount;
    private TypeDescriptor[] parameterTypes;
    private String[] parameterNames;
    private int[] parameterModes;
    private int dynamicResultSets;
    private TypeDescriptor returnType;
    private short parameterStyle;
    private short sqlAllowed;
    private String specificName;
    private boolean calledOnNullInput;

    public int getParameterCount() {
        return this.parameterCount;
    }

    public TypeDescriptor[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterModes() {
        return this.parameterModes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int getMaxDynamicResultSets() {
        return this.dynamicResultSets;
    }

    public short getParameterStyle() {
        return this.parameterStyle;
    }

    public short getSQLAllowed() {
        return this.sqlAllowed;
    }

    public boolean calledOnNullInput() {
        return this.calledOnNullInput;
    }

    public TypeDescriptor getReturnType() {
        return this.returnType;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.specificName = (String)objectInput.readObject();
        this.dynamicResultSets = objectInput.readInt();
        this.parameterCount = objectInput.readInt();
        this.parameterStyle = objectInput.readShort();
        this.sqlAllowed = objectInput.readShort();
        this.returnType = (TypeDescriptor)objectInput.readObject();
        this.calledOnNullInput = objectInput.readBoolean();
        objectInput.readInt();
        if (this.parameterCount != 0) {
            this.parameterNames = new String[this.parameterCount];
            this.parameterTypes = new TypeDescriptor[this.parameterCount];
            ArrayUtil.readArrayItems(objectInput, this.parameterNames);
            ArrayUtil.readArrayItems(objectInput, this.parameterTypes);
            this.parameterModes = ArrayUtil.readIntArray(objectInput);
        } else {
            this.parameterNames = null;
            this.parameterTypes = null;
            this.parameterModes = null;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.specificName);
        objectOutput.writeInt(this.dynamicResultSets);
        objectOutput.writeInt(this.parameterCount);
        objectOutput.writeShort(this.parameterStyle);
        objectOutput.writeShort(this.sqlAllowed);
        objectOutput.writeObject(this.returnType);
        objectOutput.writeBoolean(this.calledOnNullInput);
        objectOutput.writeInt(0);
        if (this.parameterCount != 0) {
            ArrayUtil.writeArrayItems(objectOutput, this.parameterNames);
            ArrayUtil.writeArrayItems(objectOutput, this.parameterTypes);
            ArrayUtil.writeIntArray(objectOutput, this.parameterModes);
        }
    }

    public int getTypeFormatId() {
        return 451;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getMethodName());
        stringBuffer.append('(');
        int n = 0;
        while (n < this.parameterCount) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(RoutineAliasInfo.parameterMode(this.parameterModes[n]));
            stringBuffer.append(' ');
            stringBuffer.append(this.parameterNames[n]);
            stringBuffer.append(' ');
            stringBuffer.append(this.parameterTypes[n].getSQLstring());
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(" LANGUAGE JAVA PARAMETER STYLE JAVA ");
        stringBuffer.append(SQL_CONTROL[this.getSQLAllowed()]);
        if (this.dynamicResultSets != 0) {
            stringBuffer.append(" DYNAMIC RESULT SETS ");
            stringBuffer.append(this.dynamicResultSets);
        }
        return stringBuffer.toString();
    }

    public static String parameterMode(int n) {
        switch (n) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "UNKNOWN";
    }

    public RoutineAliasInfo() {
    }

    public RoutineAliasInfo(String string, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s, short s2) {
        this(string, n, stringArray, typeDescriptorArray, nArray, n2, s, s2, true, null);
    }

    public RoutineAliasInfo(String string, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s, short s2, boolean bl, TypeDescriptor typeDescriptor) {
        super(string);
        this.parameterCount = n;
        this.parameterNames = stringArray;
        this.parameterTypes = typeDescriptorArray;
        this.parameterModes = nArray;
        this.dynamicResultSets = n2;
        this.parameterStyle = s;
        this.sqlAllowed = s2;
        this.calledOnNullInput = bl;
        this.returnType = typeDescriptor;
    }
}

