/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassInput;

class AttributeEntry {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private int attribute_name_index;
    private ClassFormatOutput infoOut;
    byte[] infoIn;

    int getNameIndex() {
        return this.attribute_name_index;
    }

    void put(ClassFormatOutput classFormatOutput) throws IOException {
        classFormatOutput.putU2(this.attribute_name_index);
        if (this.infoOut != null) {
            classFormatOutput.putU4(this.infoOut.size());
            this.infoOut.writeTo(classFormatOutput);
        } else {
            classFormatOutput.putU4(this.infoIn.length);
            classFormatOutput.write(this.infoIn);
        }
    }

    int classFileSize() {
        return 6 + (this.infoOut != null ? this.infoOut.size() : this.infoIn.length);
    }

    AttributeEntry(int n, ClassFormatOutput classFormatOutput) {
        this.attribute_name_index = n;
        this.infoOut = classFormatOutput;
    }

    AttributeEntry(ClassInput classInput) throws IOException {
        this.attribute_name_index = classInput.getU2();
        this.infoIn = classInput.getU1Array(classInput.getU4());
    }
}

