/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ApplicationObjectInputStream;
import org.apache.derby.iapi.services.io.ErrorInfo;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.Resetable;

public final class FormatIdInputStream
extends DataInputStream
implements ErrorObjectInput,
Resetable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected ClassFactory cf;
    private ErrorInfo errorInfo;
    private Exception myNestedException;

    public Object readObject() throws IOException, ClassNotFoundException {
        this.setErrorInfo(null);
        int n = FormatIdUtil.readFormatIdInteger(this);
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return this.readUTF();
        }
        try {
            if (n == 2) {
                ObjectInputStream objectInputStream = this.getObjectStream();
                try {
                    Object object = objectInputStream.readObject();
                    return object;
                }
                catch (IOException iOException) {
                    this.setErrorInfo((ErrorInfo)((Object)objectInputStream));
                    throw iOException;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setErrorInfo((ErrorInfo)((Object)objectInputStream));
                    throw classNotFoundException;
                }
                catch (LinkageError linkageError) {
                    this.setErrorInfo((ErrorInfo)((Object)objectInputStream));
                    throw linkageError;
                }
                catch (ClassCastException classCastException) {
                    this.setErrorInfo((ErrorInfo)((Object)objectInputStream));
                    throw classCastException;
                }
            }
            try {
                boolean bl;
                Formatable formatable = (Formatable)Monitor.newInstanceFromIdentifier(n);
                if (formatable instanceof Storable && (bl = this.readBoolean())) {
                    Storable storable = (Storable)formatable;
                    storable.restoreToNull();
                    return storable;
                }
                formatable.readExternal(this);
                return formatable;
            }
            catch (StandardException standardException) {
                throw new ClassNotFoundException(standardException.toString());
            }
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(classCastException.toString());
        }
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getErrorInfo() {
        if (this.errorInfo == null) {
            return "";
        }
        return this.errorInfo.getErrorInfo();
    }

    public Exception getNestedException() {
        if (this.myNestedException != null) {
            return null;
        }
        if (this.errorInfo == null) {
            return null;
        }
        return this.errorInfo.getNestedException();
    }

    private void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    ClassFactory getClassFactory() {
        ClassFactoryContext classFactoryContext;
        if (this.cf == null && (classFactoryContext = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext")) != null) {
            this.cf = classFactoryContext.getClassFactory();
        }
        return this.cf;
    }

    private ObjectInputStream getObjectStream() throws IOException {
        return this.getClassFactory() == null ? new ObjectInputStream(this) : new ApplicationObjectInputStream(this, this.cf);
    }

    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.in)).resetStream();
    }

    public void initStream() throws StandardException {
        ((Resetable)((Object)this.in)).initStream();
    }

    public void closeStream() {
        ((Resetable)((Object)this.in)).closeStream();
    }

    static /* synthetic */ InputStream access$0(FormatIdInputStream formatIdInputStream) {
        return formatIdInputStream.in;
    }

    public FormatIdInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

