/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SyncFailedException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public class DirStorageFactory
extends BaseStorageFactory
implements WritableStorageFactory {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 2004.";

    public final StorageFile newStorageFile(String string) {
        return this.newPersistentFile(string);
    }

    public final StorageFile newStorageFile(String string, String string2) {
        return this.newPersistentFile(string, string2);
    }

    public final StorageFile newStorageFile(StorageFile storageFile, String string) {
        return this.newPersistentFile(storageFile, string);
    }

    StorageFile newPersistentFile(String string) {
        if (string == null) {
            return new DirFile(this.dataDirectory);
        }
        return new DirFile(this.dataDirectory, string);
    }

    StorageFile newPersistentFile(String string, String string2) {
        return new DirFile(this.separatedDataDirectory + string, string2);
    }

    StorageFile newPersistentFile(StorageFile storageFile, String string) {
        return new DirFile((DirFile)storageFile, string);
    }

    public void sync(OutputStream outputStream, boolean bl) throws IOException, SyncFailedException {
        ((FileOutputStream)outputStream).getFD().sync();
    }

    public boolean supportsRws() {
        return false;
    }

    public boolean isReadOnlyDatabase() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    void doInit() throws IOException {
        if (this.dataDirectory != null) {
            File file = new File(this.dataDirectory);
            File file2 = null;
            file2 = file.isAbsolute() ? file : (this.home != null && this.dataDirectory.startsWith(this.home) ? file : new File(this.home, this.dataDirectory));
            this.canonicalName = file2.getCanonicalPath();
            this.createTempDir();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        } else if (this.home != null) {
            File file = new File(this.home);
            this.dataDirectory = file.getCanonicalPath();
            this.separatedDataDirectory = this.dataDirectory + this.getSeparator();
        }
    }
}

