/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;

class EmbedBlob
extends ConnectionChild
implements Blob {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private static int BLOB_BUF_SIZE = 4096;
    private boolean isBytes;
    private InputStream myStream;
    private byte[] myBytes;
    private long pos;
    private BinaryToRawStream biStream;
    private byte[] buf;

    private void setPosition(long l) throws StandardException, IOException {
        if (this.isBytes) {
            this.pos = l;
        } else {
            ((Resetable)((Object)this.myStream)).resetStream();
            this.biStream = new BinaryToRawStream(this.myStream, this);
            this.pos = 0L;
            while (this.pos < l) {
                int n = this.biStream.read(this.buf, 0, (int)Math.min(l - this.pos, (long)BLOB_BUF_SIZE));
                if (n <= 0) {
                    throw StandardException.newException("XJ079.S");
                }
                this.pos += (long)n;
            }
        }
    }

    private int read() throws IOException {
        int n;
        if (this.isBytes) {
            if (this.pos >= (long)this.myBytes.length) {
                return -1;
            }
            n = this.myBytes[(int)this.pos];
        } else {
            n = this.biStream.read();
        }
        ++this.pos;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() throws SQLException {
        long l;
        boolean bl;
        block13: {
            long l2;
            block11: {
                bl = false;
                try {
                    try {
                        long l3;
                        if (this.isBytes) {
                            l2 = this.myBytes.length;
                            Object var3_4 = null;
                            if (!bl) return l2;
                            break block11;
                        }
                        Object object = this.getConnectionSynchronization();
                        synchronized (object) {
                            boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                            if (bl) {
                                this.setupContextStack();
                            }
                            this.setPosition(0L);
                            while (true) {
                                int n;
                                if ((n = this.biStream.read(this.buf)) == -1) {
                                    l3 = this.pos;
                                    Object var7_11 = null;
                                    break;
                                }
                                this.pos += (long)n;
                            }
                        }
                        l = l3;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw this.handleMyExceptions(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    if (!bl) throw throwable;
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            return l2;
        }
        Object var3_5 = null;
        if (!bl) return l;
        this.restoreContextStack();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        boolean bl;
        block18: {
            byte[] byArray2;
            block17: {
                bl = false;
                try {
                    try {
                        byte[] byArray3;
                        block16: {
                            if (l < 1L) {
                                throw StandardException.newException("XJ070.S", new Long(l));
                            }
                            if (n <= 0) {
                                throw StandardException.newException("XJ071.S", new Integer(n));
                            }
                            if (this.isBytes) {
                                if ((long)this.myBytes.length < l) {
                                    throw StandardException.newException("XJ076.S", new Long(l));
                                }
                                int n2 = this.myBytes.length - (int)l + 1;
                                int n3 = n > n2 ? n2 : n;
                                byArray3 = new byte[n3];
                                System.arraycopy(this.myBytes, (int)l - 1, byArray3, 0, n3);
                            } else {
                                byte[] byArray4;
                                block15: {
                                    Object object = this.getConnectionSynchronization();
                                    synchronized (object) {
                                        boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                                        if (bl) {
                                            this.setupContextStack();
                                        }
                                        this.setPosition(l - 1L);
                                        byArray3 = new byte[n];
                                        int n4 = InputStreamUtil.readLoop(this.biStream, byArray3, 0, n);
                                        this.pos += (long)n4;
                                        if (n4 < n) {
                                            byte[] byArray5 = new byte[n4];
                                            System.arraycopy(byArray3, 0, byArray5, 0, n4);
                                            byArray4 = byArray5;
                                            Object var10_7 = null;
                                            break block15;
                                        }
                                        break block16;
                                    }
                                }
                                byArray2 = byArray4;
                                Object var6_17 = null;
                                if (!bl) return byArray2;
                                break block17;
                            }
                        }
                        byArray = byArray3;
                        break block18;
                    }
                    catch (StandardException standardException) {
                        StandardException standardException2;
                        if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException2);
                        standardException2 = StandardException.newException("XJ076.S", new Long(l));
                        throw this.handleMyExceptions(standardException2);
                    }
                    catch (Throwable throwable) {
                        throw this.handleMyExceptions(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_19 = null;
                    if (!bl) throw throwable;
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            return byArray2;
        }
        Object var6_18 = null;
        if (!bl) return byArray;
        this.restoreContextStack();
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream() throws SQLException {
        BinaryToRawStream binaryToRawStream;
        boolean bl;
        block10: {
            NewByteArrayInputStream newByteArrayInputStream;
            block9: {
                bl = false;
                try {
                    try {
                        BinaryToRawStream binaryToRawStream2;
                        if (this.isBytes) {
                            newByteArrayInputStream = new NewByteArrayInputStream(this.myBytes);
                            Object var3_4 = null;
                            if (!bl) return newByteArrayInputStream;
                            break block9;
                        }
                        Object object = this.getConnectionSynchronization();
                        synchronized (object) {
                            boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                            if (bl) {
                                this.setupContextStack();
                            }
                            this.setPosition(0L);
                            binaryToRawStream2 = this.biStream;
                            Object var6_10 = null;
                        }
                        binaryToRawStream = binaryToRawStream2;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw this.handleMyExceptions(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    if (!bl) throw throwable;
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            return newByteArrayInputStream;
        }
        Object var3_5 = null;
        if (!bl) return binaryToRawStream;
        this.restoreContextStack();
        return binaryToRawStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(byte[] byArray, long l) throws SQLException {
        boolean bl = false;
        try {
            try {
                if (l < 1L) {
                    throw StandardException.newException("XJ070.S", new Long(l));
                }
                if (byArray == null) {
                    throw StandardException.newException("XJ072.S");
                }
                if (byArray.length == 0) {
                    long l2 = l;
                    Object var6_8 = null;
                    if (!bl) return l2;
                    this.restoreContextStack();
                    return l2;
                }
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.setPosition(l - 1L);
                    byte by = byArray[0];
                    while (true) {
                        int n;
                        if ((n = this.read()) == -1) {
                            long l3 = -1L;
                            Object var10_21 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 8, 10] lbl28 : MonitorExitStatement: MONITOREXIT : var9_13
                            long l4 = l3;
                            Object var6_9 = null;
                            if (!bl) return l4;
                            this.restoreContextStack();
                            return l4;
                        }
                        if (n != by) continue;
                        long l5 = this.pos;
                        if (this.checkMatch(byArray)) {
                            long l6 = l5;
                            Object var10_22 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 8, 9] lbl41 : MonitorExitStatement: MONITOREXIT : var9_13
                            long l7 = l6;
                            Object var6_10 = null;
                            if (!bl) return l7;
                            this.restoreContextStack();
                            return l7;
                        }
                        this.setPosition(l5);
                    }
                }
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException);
                long l8 = -1L;
                Object var6_11 = null;
                if (!bl) return l8;
                this.restoreContextStack();
                return l8;
            }
            catch (Throwable throwable) {
                throw this.handleMyExceptions(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (!bl) throw throwable;
            this.restoreContextStack();
            throw throwable;
        }
    }

    private boolean checkMatch(byte[] byArray) throws IOException {
        int n = 1;
        while (n < byArray.length) {
            int n2 = this.read();
            if (n2 < 0 || n2 != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position(Blob blob, long l) throws SQLException {
        boolean bl = false;
        try {
            try {
                if (l < 1L) {
                    throw StandardException.newException("XJ070.S", new Long(l));
                }
                if (blob == null) {
                    throw StandardException.newException("XJ072.S");
                }
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    byte[] byArray;
                    boolean bl2 = bl = !this.getEmbedConnection().isClosed();
                    if (bl) {
                        this.setupContextStack();
                    }
                    this.setPosition(l - 1L);
                    try {
                        byArray = blob.getBytes(1L, 1);
                    }
                    catch (SQLException sQLException) {
                        throw StandardException.newException("XJ077.S");
                    }
                    if (byArray == null || byArray.length < 1) {
                        long l2 = l;
                        Object var10_13 = null;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 13] lbl24 : MonitorExitStatement: MONITOREXIT : var9_4
                        long l3 = l2;
                        Object var6_20 = null;
                        if (!bl) return l3;
                        this.restoreContextStack();
                        return l3;
                    }
                    byte by = byArray[0];
                    while (true) {
                        int n;
                        if ((n = this.read()) == -1) {
                            long l4 = -1L;
                            Object var10_14 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 10, 12] lbl37 : MonitorExitStatement: MONITOREXIT : var9_4
                            long l5 = l4;
                            Object var6_21 = null;
                            if (!bl) return l5;
                            this.restoreContextStack();
                            return l5;
                        }
                        if (n != by) continue;
                        long l6 = this.pos;
                        if (this.checkMatch(blob)) {
                            long l7 = l6;
                            Object var10_15 = null;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 10, 11] lbl50 : MonitorExitStatement: MONITOREXIT : var9_4
                            long l8 = l7;
                            Object var6_22 = null;
                            if (!bl) return l8;
                            this.restoreContextStack();
                            return l8;
                        }
                        this.setPosition(l6);
                    }
                }
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(standardException);
                long l9 = -1L;
                Object var6_23 = null;
                if (!bl) return l9;
                this.restoreContextStack();
                return l9;
            }
            catch (Throwable throwable) {
                throw this.handleMyExceptions(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var6_24 = null;
            if (!bl) throw throwable;
            this.restoreContextStack();
            throw throwable;
        }
    }

    private boolean checkMatch(Blob blob) throws IOException {
        int n;
        InputStream inputStream;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            return false;
        }
        if (inputStream == null) {
            return false;
        }
        int n2 = inputStream.read();
        if (n2 < 0) {
            return false;
        }
        do {
            if ((n2 = inputStream.read()) >= 0) continue;
            return true;
        } while (n2 == (n = this.read()) && n >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getMessageId().equals("40XD0")) {
            throwable = StandardException.newException("XJ073.S");
        }
        return this.handleException(throwable);
    }

    protected void finalize() {
        if (!this.isBytes) {
            ((Resetable)((Object)this.myStream)).closeStream();
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw Util.notImplemented();
    }

    public void truncate(long l) throws SQLException {
        throw Util.notImplemented();
    }

    protected EmbedBlob(DataValueDescriptor dataValueDescriptor, EmbedConnection embedConnection) throws StandardException {
        super(embedConnection);
        this.myStream = dataValueDescriptor.getStream();
        if (this.myStream == null) {
            this.isBytes = true;
            byte[] byArray = dataValueDescriptor.getBytes();
            this.myBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.myBytes, 0, byArray.length);
        } else {
            this.isBytes = false;
            ((Resetable)((Object)this.myStream)).initStream();
            this.buf = new byte[BLOB_BUF_SIZE];
        }
        this.pos = 0L;
    }
}

