/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.Driver169;

public final class TransactionResourceImpl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    protected ContextManager cm;
    protected ContextService csf;
    protected String username;
    private String dbname;
    private Driver169 driver;
    private String url;
    private String drdaID;
    protected Database database;
    protected LanguageConnectionContext lcc;

    void setDatabase(Database database) {
        this.database = database;
    }

    void startTransaction() throws StandardException, SQLException {
        this.lcc = this.database.setupConnection(this.cm, this.username, this.drdaID, this.dbname);
    }

    Driver169 getDriver() {
        return this.driver;
    }

    ContextService getCsf() {
        return this.csf;
    }

    ContextManager getContextManager() {
        return this.cm;
    }

    LanguageConnectionContext getLcc() {
        return this.lcc;
    }

    String getDBName() {
        return this.dbname;
    }

    String getUrl() {
        return this.url;
    }

    Database getDatabase() {
        return this.database;
    }

    StandardException shutdownDatabaseException() {
        StandardException standardException = StandardException.newException("08006.D", this.getDBName());
        standardException.setReport(1);
        return standardException;
    }

    protected void commit() throws StandardException {
        this.lcc.userCommit();
    }

    protected void rollback() throws StandardException {
        if (this.lcc != null) {
            this.lcc.userRollback();
        }
    }

    void clearContextInError() {
        this.csf.resetCurrentContextManager(this.cm);
        this.cm = null;
    }

    protected void clearLcc() {
        this.lcc = null;
    }

    protected final void setupContextStack() {
        this.csf.setCurrentContextManager(this.cm);
    }

    protected final void restoreContextStack() {
        if (this.csf == null || this.cm == null) {
            return;
        }
        this.csf.resetCurrentContextManager(this.cm);
    }

    protected final SQLException handleException(Throwable throwable, boolean bl, boolean bl2) throws SQLException {
        try {
            if (throwable instanceof SQLException) {
                return (SQLException)throwable;
            }
            boolean bl3 = false;
            if (throwable instanceof StandardException) {
                StandardException standardException = (StandardException)throwable;
                int n = standardException.getSeverity();
                if (n <= 20000) {
                    if (bl && bl2) {
                        standardException.setSeverity(30000);
                    }
                } else if ("08000".equals(standardException.getMessageId())) {
                    bl3 = true;
                }
            }
            if (this.cm != null) {
                boolean bl4 = this.cleanupOnError(throwable);
                if (bl3 && bl4) {
                    throwable = this.shutdownDatabaseException();
                }
            }
            return TransactionResourceImpl.wrapInSQLException(null, throwable);
        }
        catch (Throwable throwable2) {
            if (this.cm != null) {
                this.cm.cleanupOnError(throwable2);
            }
            throw TransactionResourceImpl.wrapInSQLException(null, throwable2);
        }
    }

    public static final SQLException wrapInSQLException(SQLException sQLException, Throwable throwable) {
        SQLException sQLException2;
        if (throwable == null) {
            return sQLException;
        }
        if (throwable instanceof SQLException) {
            sQLException2 = (SQLException)throwable;
        } else if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            sQLException2 = Util.generateCsSQLException(standardException);
            TransactionResourceImpl.wrapInSQLException(sQLException2, standardException.getNestedException());
        } else {
            sQLException2 = Util.javaException(throwable);
            Throwable throwable2 = null;
            if (throwable instanceof ExceptionInInitializerError) {
                throwable2 = ((ExceptionInInitializerError)throwable).getException();
            } else if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            if (throwable2 != null) {
                TransactionResourceImpl.wrapInSQLException(sQLException2, throwable2);
            }
        }
        if (sQLException != null) {
            sQLException.setNextException(sQLException2);
        }
        return sQLException2;
    }

    String getUserName() {
        return this.username;
    }

    public boolean cleanupOnError(Throwable throwable) {
        return this.cm.cleanupOnError(throwable);
    }

    public boolean isIdle() {
        return this.lcc == null || this.lcc.getTransactionExecute().isIdle();
    }

    boolean isActive() {
        return this.driver.isActive() && (this.database == null || this.database.isActive());
    }

    TransactionResourceImpl(Driver169 driver169, String string, Properties properties) throws SQLException {
        this.driver = driver169;
        this.csf = driver169.getContextServiceFactory();
        this.dbname = Driver169.getDatabaseName(string, properties);
        this.url = string;
        this.username = properties.getProperty("user", "APP");
        if (this.username.equals("")) {
            this.username = "APP";
        }
        this.drdaID = properties.getProperty("drdaID", null);
        this.cm = this.csf.newContextManager();
    }
}

