/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public final class CharTypeCompiler
extends BaseTypeCompiler {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        if (this.correspondingTypeId.isLongConcatableTypeId() || typeId.isLongConcatableTypeId()) {
            return false;
        }
        if (typeId.isStringTypeId() || typeId.isDateTimeTimeStampTypeID() || typeId.isBooleanTypeId()) {
            return true;
        }
        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
        return typeId.userType() && typeCompiler.comparable(this.correspondingTypeId, bl, classFactory);
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        if (this.correspondingTypeId.isLongVarcharTypeId()) {
            return typeId.isStringTypeId();
        }
        if (bl && typeId.isDoubleTypeId()) {
            return this.correspondingTypeId.isStringTypeId();
        }
        return !typeId.isFloatingPointTypeId() && !typeId.isBitTypeId() && !typeId.isBlobTypeId();
    }

    public boolean compatible(TypeId typeId) {
        return typeId.isStringTypeId() || typeId.isDateTimeTimeStampTypeId() && !this.correspondingTypeId.isLongVarcharTypeId();
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (this.convertible(typeId, false) && !typeId.isBlobTypeId() && !typeId.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.lang.String";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    public String getMatchingNationalCharTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 5: 
            case 370: {
                return "NATIONAL CHAR";
            }
            case 230: 
            case 362: {
                return "LONG NVARCHAR";
            }
            case 13: 
            case 369: {
                return "NATIONAL CHAR VARYING";
            }
        }
        return null;
    }

    protected String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 5: {
                return "getNullChar";
            }
            case 230: {
                return "getNullLongvarchar";
            }
            case 370: {
                return "getNullNationalChar";
            }
            case 362: {
                return "getNullNationalLongvarchar";
            }
            case 369: {
                return "getNullNationalVarchar";
            }
            case 13: {
                return "getNullVarchar";
            }
        }
        return null;
    }

    protected String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 5: {
                return "getCharDataValue";
            }
            case 230: {
                return "getLongvarcharDataValue";
            }
            case 370: {
                return "getNationalCharDataValue";
            }
            case 362: {
                return "getNationalLongvarcharDataValue";
            }
            case 369: {
                return "getNationalVarcharDataValue";
            }
            case 13: {
                return "getVarcharDataValue";
            }
        }
        return null;
    }
}

