/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

public class HashJoinStrategy
extends BaseJoinStrategy {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";

    public boolean feasible(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        int[] nArray = null;
        ConglomerateDescriptor conglomerateDescriptor = null;
        if (!optimizable.isMaterializable()) {
            optimizer.trace(24, 0, 0, 0.0, null);
            return false;
        }
        if (optimizable.isTargetTable()) {
            return false;
        }
        if (optimizable.isBaseTable()) {
            conglomerateDescriptor = optimizable.getCurrentAccessPath().getConglomerateDescriptor();
        }
        return (nArray = this.findHashKeyColumns(optimizable, conglomerateDescriptor, optimizablePredicateList)) != null;
    }

    public boolean ignoreBulkFetch() {
        return true;
    }

    public boolean multiplyBaseCostByOuterRows() {
        return false;
    }

    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, Optimizable optimizable) throws StandardException {
        int n = optimizablePredicateList.size() - 1;
        while (n >= 0) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList.getOptPredicate(n);
            if (optimizable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
                optimizablePredicateList2.addOptPredicate(optimizablePredicate);
                optimizablePredicateList.removeOptPredicate(n);
            }
            --n;
        }
        optimizablePredicateList2.classify(optimizable, optimizable.getCurrentAccessPath().getConglomerateDescriptor());
        return optimizablePredicateList2;
    }

    public double nonBasePredicateSelectivity(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList) {
        double d = 1.0;
        if (optimizablePredicateList != null) {
            int n = 0;
            while (n < optimizablePredicateList.size()) {
                if (!optimizablePredicateList.isRedundantPredicate(n)) {
                    d *= optimizablePredicateList.getOptPredicate(n).selectivity(optimizable);
                }
                ++n;
            }
        }
        return d;
    }

    public void putBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2) throws StandardException {
        int n = optimizablePredicateList2.size() - 1;
        while (n >= 0) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList2.getOptPredicate(n);
            optimizablePredicateList.addOptPredicate(optimizablePredicate);
            optimizablePredicateList2.removeOptPredicate(n);
            --n;
        }
    }

    public void estimateCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, CostEstimate costEstimate2) {
    }

    public double memoryUsage(double d, double d2) {
        return d * d2;
    }

    public String getName() {
        return "HASH";
    }

    public int scanCostType() {
        return 1;
    }

    public String resultSetMethodName(boolean bl) {
        return "getHashScanResultSet";
    }

    public String joinResultSetMethodName() {
        return "getHashJoinResultSet";
    }

    public String halfOuterJoinResultSetMethodName() {
        return "getHashLeftOuterJoinResultSet";
    }

    public int getScanArgs(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n, MethodBuilder methodBuilder2, int n2, int n3, int n4, boolean bl, int n5) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        this.fillInScanArgs1(transactionController, methodBuilder, optimizable, optimizablePredicateList, expressionClassBuilder, methodBuilder2);
        optimizablePredicateList2.generateQualifiers(expressionClassBuilder, methodBuilder, optimizable, true);
        methodBuilder.push(optimizable.initialCapacity());
        methodBuilder.push(optimizable.loadFactor());
        methodBuilder.push(optimizable.maxCapacity());
        int[] nArray = optimizable.hashKeyColumns();
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(nArray);
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n6 = expressionClassBuilder.addItem(formatableArrayHolder);
        methodBuilder.push(n6);
        this.fillInScanArgs2(methodBuilder, optimizable, n, n2, n3, n4, bl, n5);
        return 28;
    }

    public void divideUpPredicateLists(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, OptimizablePredicateList optimizablePredicateList3, OptimizablePredicateList optimizablePredicateList4, DataDictionary dataDictionary) throws StandardException {
        int n;
        Object object;
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList4);
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        optimizablePredicateList.transferPredicates(optimizablePredicateList2, optimizable.getReferencedTableMap(), optimizable);
        int n2 = optimizablePredicateList2.size() - 1;
        while (n2 >= 0) {
            object = (Predicate)optimizablePredicateList2.getOptPredicate(n2);
            if (!(((Predicate)object).isStoreQualifier() || ((Predicate)object).isStartKey() || ((Predicate)object).isStopKey())) {
                optimizablePredicateList2.removeOptPredicate(n2);
            }
            --n2;
        }
        n2 = optimizablePredicateList.size() - 1;
        while (n2 >= 0) {
            object = (Predicate)optimizablePredicateList.getOptPredicate(n2);
            if (!((Predicate)object).isStoreQualifier()) {
                optimizablePredicateList.removeOptPredicate(n2);
            }
            --n2;
        }
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList3);
        Optimizable optimizable2 = optimizable;
        if (optimizable instanceof ProjectRestrictNode && ((SingleChildResultSetNode)(object = (ProjectRestrictNode)optimizable)).getChildResult() instanceof Optimizable) {
            optimizable2 = (Optimizable)((Object)((SingleChildResultSetNode)object).getChildResult());
        }
        if ((object = (Object)this.findHashKeyColumns(optimizable2, conglomerateDescriptor, optimizablePredicateList3)) == null) {
            String string = conglomerateDescriptor != null && conglomerateDescriptor.isIndex() ? conglomerateDescriptor.getConglomerateName() : optimizable.getBaseTableName();
            throw StandardException.newException("42Y63", string, (Object)optimizable.getBaseTableName());
        }
        optimizable.setHashKeyColumns((int[])object);
        optimizablePredicateList3.markAllPredicatesQualifiers();
        int[] nArray = new int[((Object)object).length];
        if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex()) {
            n = 0;
            while (n < ((Object)object).length) {
                nArray[n] = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[object[n]];
                ++n;
            }
        } else {
            n = 0;
            while (n < ((Object)object).length) {
                nArray[n] = (int)(object[n] + true);
                ++n;
            }
        }
        n = ((Object)object).length - 1;
        while (n >= 0) {
            optimizablePredicateList3.putOptimizableEqualityPredicateFirst(optimizable, nArray[n]);
            --n;
        }
    }

    public boolean isHashJoin() {
        return true;
    }

    public boolean doesMaterialization() {
        return true;
    }

    private int[] findHashKeyColumns(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        int n;
        if (optimizablePredicateList == null) {
            return null;
        }
        int[] nArray = null;
        if (conglomerateDescriptor == null) {
            nArray = new int[optimizable.getNumColumnsReturned()];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = n + 1;
                ++n;
            }
        } else if (conglomerateDescriptor.isIndex()) {
            nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        } else {
            nArray = new int[optimizable.getTableDescriptor().getNumberOfColumns()];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = n + 1;
                ++n;
            }
        }
        Vector<Integer> vector = new Vector<Integer>();
        n = 0;
        while (n < nArray.length) {
            if (optimizablePredicateList.hasOptimizableEquijoin(optimizable, nArray[n])) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
        if (vector.size() > 0) {
            int[] nArray2 = new int[vector.size()];
            int n2 = 0;
            while (n2 < nArray2.length) {
                nArray2[n2] = (Integer)vector.elementAt(n2);
                ++n2;
            }
            return nArray2;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

