/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    protected LanguageConnectionContext lcc;
    private SQLWarning warnings;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected Activation activation;
    private boolean statisticsTimingOn;
    ResultDescription resultDescription;
    private transient ExecutionFactory exFactory;
    private transient TransactionController tc;
    private int[] baseColumnMap;

    public abstract void openCore() throws StandardException;

    public void reopenCore() throws StandardException {
        this.close();
        this.openCore();
    }

    public abstract ExecRow getNextRowCore() throws StandardException;

    public int getPointOfAttachment() {
        return -1;
    }

    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    public int getScanIsolationLevel() {
        return 0;
    }

    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    public boolean requiresRelocking() {
        return false;
    }

    public final void open() throws StandardException {
        this.finished = false;
        this.attachStatementContext();
        try {
            this.openCore();
        }
        catch (StandardException standardException) {
            this.activation.checkStatementValidity();
            throw standardException;
        }
        this.activation.checkStatementValidity();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "absolute");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "relative");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        return null;
    }

    public boolean checkRowPosition(int n) throws StandardException {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "first");
        }
        this.attachStatementContext();
        return null;
    }

    public final ExecRow getNextRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "previous");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        this.attachStatementContext();
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "last");
        }
        return null;
    }

    public boolean returnsRows() {
        return true;
    }

    public final int modifiedRowCount() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        if (this.isOpen) {
            this.close();
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            LanguageConnectionContext languageConnectionContext;
            if (this.isTopResultSet && (languageConnectionContext = this.getLanguageConnectionContext()).getRunTimeStatisticsMode()) {
                HeaderPrintWriter headerPrintWriter;
                this.endExecutionTime = this.getCurrentTimeMillis();
                languageConnectionContext.setRunTimeStatisticsObject(languageConnectionContext.getExecutionContext().getResultSetStatisticsFactory().getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter2 = headerPrintWriter = languageConnectionContext.getLogQueryPlan() ? Monitor.getStream() : null;
                if (headerPrintWriter != null) {
                    headerPrintWriter.printlnWithHeader("(XID = " + languageConnectionContext.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + languageConnectionContext.getRunTimeStatisticsObject().getStatementText() + " ******* " + languageConnectionContext.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            if (!this.isClosed()) {
                this.close();
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public long getExecuteTime() {
        return this.getTimeSpent(1);
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedMillis(long l) {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis() - l;
        }
        return 0L;
    }

    protected final String dumpTimeStats(String string, String string2) {
        return string + MessageService.getTextMessage("42Z30.U") + " " + this.getTimeSpent(0) + "\n" + string + MessageService.getTextMessage("42Z31.U") + " " + this.getTimeSpent(1) + "\n" + string + MessageService.getTextMessage("42Z32.U") + "\n" + string2 + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = this.activation != null ? this.activation.getLanguageConnectionContext() : (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int resultSetNumber() {
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        if (this.exFactory == null) {
            this.exFactory = this.activation.getExecutionFactory();
        }
        return this.exFactory;
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected ExecRow getCompactRow(ExecRow execRow, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2, boolean bl) throws StandardException {
        int n = execRow.nColumns();
        if (formatableBitSet == null) {
            this.compactRow = execRow;
            this.baseColumnMap = new int[n];
            int n2 = 0;
            while (n2 < this.baseColumnMap.length) {
                this.baseColumnMap[n2] = n2;
                ++n2;
            }
        } else {
            FormatableBitSet formatableBitSet3;
            if (formatableBitSet2 == null) {
                formatableBitSet3 = formatableBitSet;
            } else {
                formatableBitSet3 = new FormatableBitSet(formatableBitSet);
                formatableBitSet3.or(formatableBitSet2);
            }
            int n3 = formatableBitSet3.getNumBitsSet();
            this.baseColumnMap = new int[n3];
            if (this.compactRow == null) {
                ExecutionFactory executionFactory = this.lcc.getExecutionContext().getExecutionFactory();
                this.compactRow = bl ? executionFactory.getIndexableRow(n3) : executionFactory.getValueRow(n3);
            }
            int n4 = 0;
            int n5 = formatableBitSet3.anySetBit();
            while (n5 != -1) {
                if (n5 < n) {
                    DataValueDescriptor dataValueDescriptor = execRow.getColumn(n5 + 1);
                    if (dataValueDescriptor != null) {
                        this.compactRow.setColumn(n4 + 1, dataValueDescriptor);
                    }
                    this.baseColumnMap[n4] = n5;
                    ++n4;
                    n5 = formatableBitSet3.anySetBit(n5);
                    continue;
                }
                break;
            }
        }
        return this.compactRow;
    }

    protected ExecRow setCompactRow(ExecRow execRow, ExecRow execRow2) {
        ExecRow execRow3;
        if (this.baseColumnMap == null) {
            execRow3 = execRow;
        } else {
            execRow3 = execRow2;
            this.setCompatRow(execRow2, execRow.getRowArray());
        }
        return execRow3;
    }

    protected final void setCompatRow(ExecRow execRow, Object[] objectArray) {
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        int[] nArray = this.baseColumnMap;
        int n = 0;
        while (n < nArray.length) {
            dataValueDescriptorArray[n] = objectArray[nArray[n]];
            ++n;
        }
    }

    public boolean isForUpdate() {
        return false;
    }

    protected final void addWarning(SQLWarning sQLWarning) {
        ResultSet resultSet;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextWarning(sQLWarning);
            }
            return;
        }
        if (this.activation != null && (resultSet = this.activation.getResultSet()) instanceof BasicNoPutResultSetImpl) {
            ((BasicNoPutResultSetImpl)resultSet).addWarning(sQLWarning);
        }
    }

    public final SQLWarning getWarnings() {
        SQLWarning sQLWarning = this.warnings;
        this.warnings = null;
        return sQLWarning;
    }

    public abstract void setTargetResultSet(TargetResultSet var1);

    public abstract void setNeedsRowLocation(boolean var1);

    public abstract void setCurrentRow(ExecRow var1);

    public abstract void clearCurrentRow();

    public abstract void close() throws StandardException;

    public abstract long getTimeSpent(int var1);

    public abstract String getCursorName();

    public abstract boolean needsRowLocation();

    public abstract void rowLocation(RowLocation var1) throws StandardException;

    public abstract DataValueDescriptor[] getNextRowFromRowSource() throws StandardException;

    public abstract boolean needsToClone();

    public abstract FormatableBitSet getValidColumns();

    public abstract void closeRowSource();

    BasicNoPutResultSetImpl(ResultDescription resultDescription, Activation activation, double d, double d2) {
        this.activation = activation;
        this.statisticsTimingOn = activation != null && this.getLanguageConnectionContext().getStatisticsTiming();
        this.beginTime = this.startExecutionTime = this.getCurrentTimeMillis();
        this.resultDescription = resultDescription;
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }
}

