/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.FKInfo;

public class RIBulkChecker {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final int LESS_THAN = -1;
    private FKInfo fkInfo;
    private GroupFetchScanController referencedKeyScan;
    private DataValueDescriptor[][] referencedKeyRowArray;
    private GroupFetchScanController foreignKeyScan;
    private DataValueDescriptor[][] foreignKeyRowArray;
    private ConglomerateController unreferencedCC;
    private int failedCounter;
    private boolean quitOnFirstFailure;
    private int numColumns;
    private int currRefRowIndex;
    private int currFKRowIndex;
    private int lastRefRowIndex;
    private int lastFKRowIndex;
    private ExecRow firstRowToFail;

    /*
     * Unable to fully structure code
     */
    public int doCheck() throws StandardException {
        var2_1 = this.getNextRef();
        while ((var1_2 = this.getNextFK()) != null) {
            if (this.anyNull(var1_2) || var2_1 != null) ** GOTO lbl18
            do {
                this.failure(var1_2);
                if (!this.quitOnFirstFailure) continue;
                return 1;
            } while ((var1_2 = this.getNextFK()) != null);
            return this.failedCounter;
lbl-1000:
            // 1 sources

            {
                var2_1 = this.getNextRef();
                if (var2_1 != null) continue;
                do {
                    this.failure(var1_2);
                    if (!this.quitOnFirstFailure) continue;
                    return 1;
                } while ((var1_2 = this.getNextFK()) != null);
                return this.failedCounter;
lbl18:
                // 2 sources

                ** while ((var3_3 = this.greaterThan((DataValueDescriptor[])var1_2, (DataValueDescriptor[])var2_1)) == 1)
            }
lbl19:
            // 1 sources

            if (var3_3 == 0) continue;
            this.failure(var1_2);
            if (!this.quitOnFirstFailure) continue;
            return 1;
        }
        return this.failedCounter;
    }

    private DataValueDescriptor[] getNextFK() throws StandardException {
        if (this.currFKRowIndex > this.lastFKRowIndex || this.currFKRowIndex == -1) {
            int n = this.foreignKeyScan.fetchNextGroup(this.foreignKeyRowArray, null);
            if (n == 0) {
                this.currFKRowIndex = -1;
                return null;
            }
            this.lastFKRowIndex = n - 1;
            this.currFKRowIndex = 0;
        }
        return this.foreignKeyRowArray[this.currFKRowIndex++];
    }

    private DataValueDescriptor[] getNextRef() throws StandardException {
        if (this.currRefRowIndex > this.lastRefRowIndex || this.currRefRowIndex == -1) {
            int n = this.referencedKeyScan.fetchNextGroup(this.referencedKeyRowArray, null);
            if (n == 0) {
                this.currRefRowIndex = -1;
                return null;
            }
            this.lastRefRowIndex = n - 1;
            this.currRefRowIndex = 0;
        }
        return this.referencedKeyRowArray[this.currRefRowIndex++];
    }

    private void failure(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.failedCounter == 0 && this.firstRowToFail != null) {
            this.firstRowToFail.setRowArray(dataValueDescriptorArray);
            this.firstRowToFail.setRowArray(this.firstRowToFail.getRowArrayClone());
        }
        ++this.failedCounter;
        if (this.unreferencedCC != null) {
            this.unreferencedCC.insert(dataValueDescriptorArray);
        }
    }

    private boolean anyNull(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        int n = 0;
        while (n < this.numColumns) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[n];
            if (dataValueDescriptor.isNull()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int greaterThan(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        if (this.anyNull(dataValueDescriptorArray)) {
            return 0;
        }
        int n = 0;
        while (n < this.numColumns) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[n];
            DataValueDescriptor dataValueDescriptor2 = dataValueDescriptorArray2[n];
            int n2 = dataValueDescriptor.compare(dataValueDescriptor2);
            if (n2 == 1) {
                return 1;
            }
            if (n2 == -1) {
                return -1;
            }
            ++n;
        }
        return 0;
    }

    public RIBulkChecker(GroupFetchScanController groupFetchScanController, GroupFetchScanController groupFetchScanController2, ExecRow execRow, boolean bl, ConglomerateController conglomerateController, ExecRow execRow2) {
        this.referencedKeyScan = groupFetchScanController;
        this.foreignKeyScan = groupFetchScanController2;
        this.quitOnFirstFailure = bl;
        this.unreferencedCC = conglomerateController;
        this.firstRowToFail = execRow2;
        this.foreignKeyRowArray = new DataValueDescriptor[16][];
        this.foreignKeyRowArray[0] = execRow.getRowArrayClone();
        this.referencedKeyRowArray = new DataValueDescriptor[16][];
        this.referencedKeyRowArray[0] = execRow.getRowArrayClone();
        this.failedCounter = 0;
        this.numColumns = execRow.getRowArray().length - 1;
        this.currFKRowIndex = -1;
        this.currRefRowIndex = -1;
    }
}

