/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;

public final class PurgeOperation
extends PhysicalPageOperation {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected int slot;
    protected int num_rows;
    protected int[] recordIds;
    protected transient ByteArray preparedLog;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.slot);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        int n = 0;
        while (n < this.num_rows) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[n]);
            ++n;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.slot = CompressedNumber.readInt(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        int n = 0;
        while (n < this.num_rows) {
            this.recordIds[n] = CompressedNumber.readInt(objectInput);
            ++n;
        }
    }

    public int getTypeFormatId() {
        return 106;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = this.num_rows - 1;
        while (n >= 0) {
            this.page.purgeRecord(logInstant, this.slot + n, this.recordIds[n]);
            --n;
        }
    }

    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = 0;
        while (n < this.num_rows) {
            basePage.storeRecord(logInstant, this.slot + n, true, limitObjectInput);
            ++n;
        }
        basePage.setAuxObject(null);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, boolean bl) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n = dynamicByteArrayOutputStream.getPosition();
        int n2 = 0;
        while (n2 < this.num_rows) {
            if (bl) {
                this.page.logRecord(n2 + this.slot, 0, this.recordIds[n2], null, dynamicByteArrayOutputStream, null);
            } else {
                this.page.logRecord(n2 + this.slot, 2, this.recordIds[n2], null, dynamicByteArrayOutputStream, null);
            }
            ++n2;
        }
        n2 = dynamicByteArrayOutputStream.getPosition() - n;
        dynamicByteArrayOutputStream.setPosition(n);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n, n2);
    }

    public String toString() {
        return null;
    }

    public PurgeOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int[] nArray, boolean bl) throws StandardException {
        super(basePage);
        this.slot = n;
        this.num_rows = n2;
        this.recordIds = nArray;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, bl);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public PurgeOperation() {
    }
}

