/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.VariableScopeCodeVisitor;

public class ConstructorNode
extends AnnotatedNode {
    private int modifiers;
    private Parameter[] parameters;
    private Statement code;
    private VariableScope variableScope;

    public ConstructorNode(int modifiers, Statement code) {
        this(modifiers, Parameter.EMPTY_ARRAY, code);
    }

    public ConstructorNode(int modifiers, Parameter[] parameters, Statement code) {
        this.modifiers = modifiers;
        this.parameters = parameters;
        this.code = code;
    }

    public Statement getCode() {
        return this.code;
    }

    public void setCode(Statement code) {
        this.code = code;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public VariableScope getVariableScope() {
        if (this.variableScope == null) {
            this.variableScope = this.createVariableScope();
        }
        return this.variableScope;
    }

    public void setVariableScope(VariableScope variableScope) {
        this.variableScope = variableScope;
    }

    protected VariableScope createVariableScope() {
        VariableScope variableScope = new VariableScope();
        VariableScopeCodeVisitor visitor = new VariableScopeCodeVisitor(variableScope);
        visitor.setParameters(this.getParameters());
        Statement code = this.getCode();
        if (code != null) {
            code.visit(visitor);
        }
        this.addFieldsToVisitor(variableScope);
        return variableScope;
    }
}

