/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.ClosureListener;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;

public class MetaClassHelper {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static Class[] EMPTY_TYPE_ARRAY = new Class[0];
    protected static final Object[] ARRAY_WITH_EMPTY_ARRAY = new Object[]{EMPTY_ARRAY};
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    protected static final Logger log = Logger.getLogger(MetaClassHelper.class.getName());
    private static final int MAX_ARG_LEN = 12;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$math$BigInteger;

    public static boolean accessibleToConstructor(Class at, Constructor constructor) {
        boolean accessible = false;
        if (Modifier.isPublic(constructor.getModifiers())) {
            accessible = true;
        } else if (Modifier.isPrivate(constructor.getModifiers())) {
            accessible = at.getName().equals(constructor.getName());
        } else if (Modifier.isProtected(constructor.getModifiers())) {
            if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
                accessible = true;
            } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
                accessible = false;
            } else if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
                accessible = false;
            } else if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
                accessible = true;
            } else {
                boolean flag = false;
                for (Class clazz = at; !flag && clazz != null; clazz = clazz.getSuperclass()) {
                    if (clazz.equals(constructor.getDeclaringClass())) {
                        flag = true;
                        break;
                    }
                    if (clazz.equals(class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) break;
                }
                accessible = flag;
            }
        } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
            accessible = true;
        } else if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
            accessible = false;
        } else if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
            accessible = false;
        } else if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
            accessible = true;
        }
        return accessible;
    }

    public static Object asPrimitiveArray(List list, Class parameterType) {
        Class<?> arrayType = parameterType.getComponentType();
        Object objArray = Array.newInstance(arrayType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (arrayType.isPrimitive()) {
                if (obj instanceof Integer) {
                    Array.setInt(objArray, i, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    Array.setDouble(objArray, i, (Double)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    Array.setBoolean(objArray, i, (Boolean)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    Array.setLong(objArray, i, (Long)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    Array.setFloat(objArray, i, ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Character) {
                    Array.setChar(objArray, i, ((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    Array.setByte(objArray, i, (Byte)obj);
                    continue;
                }
                if (!(obj instanceof Short)) continue;
                Array.setShort(objArray, i, (Short)obj);
                continue;
            }
            Array.set(objArray, i, obj);
        }
        return objArray;
    }

    protected static Class autoboxType(Class type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    public static int calculateParameterDistance(Class[] arguments, Class[] parameters) {
        int dist = 0;
        block0: for (int i = 0; i < arguments.length; ++i) {
            Class clazz;
            if (parameters[i] == arguments[i]) continue;
            if (parameters[i].isInterface()) {
                dist += 2;
                continue;
            }
            if (arguments[i] != null) {
                if (arguments[i].isPrimitive() || parameters[i].isPrimitive()) {
                    ++dist;
                    continue;
                }
                ++dist;
                clazz = arguments[i];
                while (clazz != null && clazz != parameters[i]) {
                    if (clazz == (class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString) && parameters[i] == (class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String)) {
                        dist += 2;
                        continue block0;
                    }
                    clazz = clazz.getSuperclass();
                    dist += 2;
                }
                continue;
            }
            --dist;
            clazz = parameters[i];
            while (clazz != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                clazz = clazz.getSuperclass();
                dist += 2;
            }
        }
        return dist;
    }

    public static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    protected static void checkForInvalidOverloading(String name, Class[] baseTypes, Class[] derivedTypes) {
        int size = baseTypes.length;
        for (int i = 0; i < size; ++i) {
            Class derivedType = derivedTypes[i];
            Class baseType = baseTypes[i];
            if (MetaClassHelper.isAssignableFrom(derivedType, baseType)) continue;
            throw new GroovyRuntimeException("Ambiguous method overloading for method: " + name + ". Cannot resolve which method to invoke due to overlapping prototypes between: " + InvokerHelper.toString(baseTypes) + " and: " + InvokerHelper.toString(derivedTypes));
        }
    }

    public static Object chooseEmptyMethodParams(List methods) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 0) continue;
            return method;
        }
        return null;
    }

    public static Object chooseMostGeneralMethodWith1NullParam(List methods) {
        Class closestClass = null;
        Object answer = null;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Class theType;
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            int paramLength = paramTypes.length;
            if (paramLength != 1 || (theType = paramTypes[0]).isPrimitive() || closestClass != null && !MetaClassHelper.isAssignableFrom(closestClass, theType)) continue;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    public static boolean coerceGStrings(Object[] arguments) {
        boolean coerced = false;
        int size = arguments.length;
        for (int i = 0; i < size; ++i) {
            Object argument = arguments[i];
            if (!(argument instanceof GString)) continue;
            arguments[i] = argument.toString();
            coerced = true;
        }
        return coerced;
    }

    protected static Object[] coerceNumbers(MetaMethod method, Object[] arguments) {
        Object[] ans = null;
        boolean coerced = false;
        Class[] params = method.getParameterTypes();
        if (params.length != arguments.length) {
            return null;
        }
        ans = new Object[arguments.length];
        int size = arguments.length;
        for (int i = 0; i < size; ++i) {
            Class<?> paramElem;
            Class param;
            Object argument = arguments[i];
            if (((class$java$lang$Number == null ? MetaClassHelper.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(param = params[i]) || param.isPrimitive()) && argument instanceof Number) {
                if (param == (class$java$lang$Byte == null ? MetaClassHelper.class$("java.lang.Byte") : class$java$lang$Byte) || param == Byte.TYPE) {
                    ans[i] = new Byte(((Number)argument).byteValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Double == null ? MetaClassHelper.class$("java.lang.Double") : class$java$lang$Double) || param == Double.TYPE) {
                    ans[i] = new Double(((Number)argument).doubleValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Float == null ? MetaClassHelper.class$("java.lang.Float") : class$java$lang$Float) || param == Float.TYPE) {
                    ans[i] = new Float(((Number)argument).floatValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Integer == null ? MetaClassHelper.class$("java.lang.Integer") : class$java$lang$Integer) || param == Integer.TYPE) {
                    ans[i] = new Integer(((Number)argument).intValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Long == null ? MetaClassHelper.class$("java.lang.Long") : class$java$lang$Long) || param == Long.TYPE) {
                    ans[i] = new Long(((Number)argument).longValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$lang$Short == null ? MetaClassHelper.class$("java.lang.Short") : class$java$lang$Short) || param == Short.TYPE) {
                    ans[i] = new Short(((Number)argument).shortValue());
                    coerced = true;
                    continue;
                }
                if (param == (class$java$math$BigDecimal == null ? MetaClassHelper.class$("java.math.BigDecimal") : class$java$math$BigDecimal)) {
                    ans[i] = new BigDecimal(((Number)argument).doubleValue());
                    coerced = true;
                    continue;
                }
                if (param != (class$java$math$BigInteger == null ? MetaClassHelper.class$("java.math.BigInteger") : class$java$math$BigInteger)) continue;
                ans[i] = new BigInteger(String.valueOf(((Number)argument).longValue()));
                coerced = true;
                continue;
            }
            if (!param.isArray() || !argument.getClass().isArray() || !(paramElem = param.getComponentType()).isPrimitive()) continue;
            if (paramElem == Boolean.TYPE && argument.getClass().getName().equals("[Ljava.lang.Boolean;")) {
                ans[i] = InvokerHelper.convertToBooleanArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Byte.TYPE && argument.getClass().getName().equals("[Ljava.lang.Byte;")) {
                ans[i] = InvokerHelper.convertToByteArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Character.TYPE && argument.getClass().getName().equals("[Ljava.lang.Character;")) {
                ans[i] = InvokerHelper.convertToCharArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Short.TYPE && argument.getClass().getName().equals("[Ljava.lang.Short;")) {
                ans[i] = InvokerHelper.convertToShortArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Integer.TYPE && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToIntArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Long.TYPE && argument.getClass().getName().equals("[Ljava.lang.Long;") && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToLongArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem == Float.TYPE && argument.getClass().getName().equals("[Ljava.lang.Float;") && argument.getClass().getName().equals("[Ljava.lang.Integer;")) {
                ans[i] = InvokerHelper.convertToFloatArray(argument);
                coerced = true;
                continue;
            }
            if (paramElem != Double.TYPE || !argument.getClass().getName().equals("[Ljava.lang.Double;") || !argument.getClass().getName().equals("[Ljava.lang.BigDecimal;") || !argument.getClass().getName().equals("[Ljava.lang.Float;")) continue;
            ans[i] = InvokerHelper.convertToDoubleArray(argument);
            coerced = true;
        }
        return coerced ? ans : null;
    }

    public static boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static Class[] convertToTypeArray(Object[] args) {
        if (args == null) {
            return null;
        }
        int s = args.length;
        Class[] ans = new Class[s];
        for (int i = 0; i < s; ++i) {
            Object o = args[i];
            ans[i] = o != null ? o.getClass() : null;
        }
        return ans;
    }

    public static Object createListenerProxy(Class listenerType, String listenerMethodName, Closure closure) {
        ClosureListener handler = new ClosureListener(listenerMethodName, closure);
        return Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
    }

    public static Object doConstructorInvoke(Constructor constructor, Object[] argumentArray) {
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(constructor.getDeclaringClass(), constructor.getName(), argumentArray);
        }
        try {
            return constructor.newInstance(argumentArray);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalArgumentException e) {
            if (MetaClassHelper.coerceGStrings(argumentArray)) {
                try {
                    return constructor.newInstance(argumentArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e);
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke constructor: " + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    public static Object doMethodInvoke(Object object, MetaMethod method, Object[] argumentArray) {
        Class[] paramTypes = method.getParameterTypes();
        try {
            if (argumentArray == null) {
                argumentArray = EMPTY_ARRAY;
            } else if (paramTypes.length == 1 && argumentArray.length == 0) {
                argumentArray = MetaClassHelper.isVargsMethod(paramTypes, argumentArray) ? ARRAY_WITH_EMPTY_ARRAY : ARRAY_WITH_NULL;
            } else if (MetaClassHelper.isVargsMethod(paramTypes, argumentArray)) {
                Object[] newArg = new Object[paramTypes.length];
                System.arraycopy(argumentArray, 0, newArg, 0, newArg.length - 1);
                Object[] vargs = new Object[argumentArray.length - newArg.length + 1];
                System.arraycopy(argumentArray, newArg.length - 1, vargs, 0, vargs.length);
                newArg[newArg.length - 1] = vargs.length == 1 && vargs[0] == null ? null : vargs;
                argumentArray = newArg;
            }
            return method.invoke(object, argumentArray);
        }
        catch (ClassCastException e) {
            if (MetaClassHelper.coerceGStrings(argumentArray)) {
                try {
                    return MetaClassHelper.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new InvokerInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("could not access method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
        catch (IllegalArgumentException e) {
            Object[] args;
            if (MetaClassHelper.coerceGStrings(argumentArray)) {
                try {
                    return MetaClassHelper.doMethodInvoke(object, method, argumentArray);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if ((args = MetaClassHelper.coerceNumbers(method, argumentArray)) != null && !Arrays.equals(argumentArray, args)) {
                try {
                    return MetaClassHelper.doMethodInvoke(object, method, args);
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + "reason: " + e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("failed to invoke method: " + method + " on: " + object + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e, e);
        }
    }

    protected static String getClassName(Object object) {
        return object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        return new MethodClosure(object, methodName);
    }

    public static Class[] getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof MetaMethod) {
            MetaMethod method = (MetaMethod)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return method.getParameterTypes();
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return constructor.getParameterTypes();
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    private static boolean implementsInterface(Class clazz, Class iface) {
        if (!iface.isInterface()) {
            return false;
        }
        return iface.isAssignableFrom(clazz);
    }

    protected static boolean isAssignableFrom(Class mostSpecificType, Class type) {
        if (mostSpecificType == null) {
            return true;
        }
        if (mostSpecificType.isPrimitive() && type.isPrimitive()) {
            if (mostSpecificType == type) {
                return true;
            }
            if (type == Integer.TYPE) {
                return mostSpecificType == Integer.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Double.TYPE) {
                return mostSpecificType == Double.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Long.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE || mostSpecificType == Float.TYPE;
            }
            if (type == Long.TYPE) {
                return mostSpecificType == Long.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Float.TYPE) {
                return mostSpecificType == Float.TYPE || mostSpecificType == Integer.TYPE || mostSpecificType == Long.TYPE || mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            if (type == Short.TYPE) {
                return mostSpecificType == Short.TYPE || mostSpecificType == Byte.TYPE;
            }
            return false;
        }
        if (type == String.class) {
            return mostSpecificType == String.class || GString.class.isAssignableFrom(mostSpecificType);
        }
        boolean answer = type.isAssignableFrom(mostSpecificType);
        if (!answer) {
            answer = MetaClassHelper.autoboxType(type).isAssignableFrom(MetaClassHelper.autoboxType(mostSpecificType));
        }
        return answer;
    }

    protected static boolean isCompatibleClass(Class type, Class value, boolean includeCoerce) {
        boolean answer;
        boolean bl = answer = value == null || type.isAssignableFrom(value);
        if (!answer) {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return value == Integer.class;
                }
                if (type == Double.TYPE) {
                    return value == Double.class || value == Float.class || value == Integer.class || value == BigDecimal.class;
                }
                if (type == Boolean.TYPE) {
                    return value == Boolean.class;
                }
                if (type == Long.TYPE) {
                    return value == Long.class || value == Integer.class;
                }
                if (type == Float.TYPE) {
                    return value == Float.class || value == Integer.class;
                }
                if (type == Character.TYPE) {
                    return value == Character.class;
                }
                if (type == Byte.TYPE) {
                    return value == Byte.class;
                }
                if (type == Short.TYPE) {
                    return value == Short.class;
                }
            } else {
                if (type.isArray() && value.isArray()) {
                    return MetaClassHelper.isCompatibleClass(type.getComponentType(), value.getComponentType(), false);
                }
                if (includeCoerce) {
                    if (type == String.class && GString.class.isAssignableFrom(value)) {
                        return true;
                    }
                    if (value == Number.class) {
                        return Number.class.isAssignableFrom(type);
                    }
                }
            }
        }
        return answer;
    }

    protected static boolean isCompatibleInstance(Class type, Object value, boolean includeCoerce) {
        boolean answer;
        boolean bl = answer = value == null || type.isInstance(value);
        if (!answer) {
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    return value instanceof Integer;
                }
                if (type == Double.TYPE) {
                    return value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof BigDecimal;
                }
                if (type == Boolean.TYPE) {
                    return value instanceof Boolean;
                }
                if (type == Long.TYPE) {
                    return value instanceof Long || value instanceof Integer;
                }
                if (type == Float.TYPE) {
                    return value instanceof Float || value instanceof Integer;
                }
                if (type == Character.TYPE) {
                    return value instanceof Character;
                }
                if (type == Byte.TYPE) {
                    return value instanceof Byte;
                }
                if (type == Short.TYPE) {
                    return value instanceof Short;
                }
            } else {
                if (type.isArray() && value.getClass().isArray()) {
                    return MetaClassHelper.isCompatibleClass(type.getComponentType(), value.getClass().getComponentType(), false);
                }
                if (includeCoerce) {
                    if (type == String.class && value instanceof GString) {
                        return true;
                    }
                    if (value instanceof Number) {
                        return Number.class.isAssignableFrom(type);
                    }
                }
            }
        }
        return answer;
    }

    public static boolean isGenericSetMethod(MetaMethod method) {
        return method.getName().equals("set") && method.getParameterTypes().length == 2;
    }

    protected static boolean isSuperclass(Class claszz, Class superclass) {
        while (claszz != null) {
            if (claszz == superclass) {
                return true;
            }
            claszz = claszz.getSuperclass();
        }
        return false;
    }

    public static boolean isValidMethod(Class[] paramTypes, Class[] arguments, boolean includeCoerce) {
        if (arguments == null) {
            return true;
        }
        int size = arguments.length;
        if ((size >= paramTypes.length || size == paramTypes.length - 1) && paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray()) {
            for (int i = 0; i < paramTypes.length - 1; ++i) {
                if (MetaClassHelper.isCompatibleClass(paramTypes[i], arguments[i], includeCoerce)) continue;
                return false;
            }
            Class<?> clazz = paramTypes[paramTypes.length - 1].getComponentType();
            for (int i = paramTypes.length; i < size; ++i) {
                if (MetaClassHelper.isCompatibleClass(clazz, arguments[i], includeCoerce)) continue;
                return false;
            }
            return true;
        }
        if (paramTypes.length == size) {
            for (int i = 0; i < size; ++i) {
                if (MetaClassHelper.isCompatibleClass(paramTypes[i], arguments[i], includeCoerce)) continue;
                return false;
            }
            return true;
        }
        return paramTypes.length == 1 && size == 0;
    }

    public static boolean isValidMethod(Object method, Class[] arguments, boolean includeCoerce) {
        Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
        return MetaClassHelper.isValidMethod(paramTypes, arguments, includeCoerce);
    }

    public static boolean isVargsMethod(Class[] paramTypes, Object[] arguments) {
        if (paramTypes.length == 0) {
            return false;
        }
        if (!paramTypes[paramTypes.length - 1].isArray()) {
            return false;
        }
        if (paramTypes.length - 1 == arguments.length) {
            return true;
        }
        if (paramTypes.length - 1 > arguments.length) {
            return false;
        }
        if (arguments.length > paramTypes.length) {
            return true;
        }
        Object last = arguments[arguments.length - 1];
        if (last == null) {
            return true;
        }
        Class<?> clazz = last.getClass();
        return !clazz.equals(paramTypes[paramTypes.length - 1]);
    }

    public static void logMethodCall(Object object, String methodName, Object[] arguments) {
        String className = MetaClassHelper.getClassName(object);
        String logname = "methodCalls." + className + "." + methodName;
        Logger objLog = Logger.getLogger(logname);
        if (!objLog.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer msg = new StringBuffer(methodName);
        msg.append("(");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                msg.append(MetaClassHelper.normalizedValue(arguments[i]));
                if (++i >= arguments.length) continue;
                msg.append(",");
            }
        }
        msg.append(")");
        objLog.logp(Level.FINER, className, msg.toString(), "called from MetaClass.invokeMethod");
    }

    protected static String normalizedValue(Object argument) {
        String value;
        try {
            value = argument.toString();
            if (value.length() > 12) {
                value = value.substring(0, 10) + "..";
            }
            if (argument instanceof String) {
                value = "'" + value + "'";
            }
        }
        catch (Exception e) {
            value = MetaClassHelper.shortName(argument);
        }
        return value;
    }

    public static boolean parametersAreCompatible(Class[] arguments, Class[] parameters) {
        if (arguments.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (MetaClassHelper.isAssignableFrom(arguments[i], parameters[i])) continue;
            return false;
        }
        return true;
    }

    protected static String shortName(Object object) {
        if (object == null || object.getClass() == null) {
            return "unknownClass";
        }
        String name = MetaClassHelper.getClassName(object);
        if (name == null) {
            return "unknownClassName";
        }
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos < 0 || lastDotPos >= name.length() - 1) {
            return name;
        }
        return name.substring(lastDotPos + 1);
    }

    public static Class[] wrap(Class[] classes) {
        Class[] wrappedArguments = new Class[classes.length];
        for (int i = 0; i < wrappedArguments.length; ++i) {
            Class c = classes[i];
            if (c == null) continue;
            if (c.isPrimitive()) {
                if (c == Integer.TYPE) {
                    c = class$java$lang$Integer == null ? MetaClassHelper.class$("java.lang.Integer") : class$java$lang$Integer;
                } else if (c == Byte.TYPE) {
                    c = class$java$lang$Byte == null ? MetaClassHelper.class$("java.lang.Byte") : class$java$lang$Byte;
                } else if (c == Long.TYPE) {
                    c = class$java$lang$Long == null ? MetaClassHelper.class$("java.lang.Long") : class$java$lang$Long;
                } else if (c == Double.TYPE) {
                    c = class$java$lang$Double == null ? MetaClassHelper.class$("java.lang.Double") : class$java$lang$Double;
                } else if (c == Float.TYPE) {
                    c = class$java$lang$Float == null ? MetaClassHelper.class$("java.lang.Float") : class$java$lang$Float;
                }
            } else if (MetaClassHelper.isSuperclass(c, class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString)) {
                c = class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String;
            }
            wrappedArguments[i] = c;
        }
        return wrappedArguments;
    }
}

