/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.MetaMethod;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class MethodCallExpression
extends Expression {
    private Expression objectExpression;
    private String method;
    private Expression arguments;
    private boolean spreadSafe = false;
    private boolean safe = false;
    private boolean implicitThis;
    private MetaMethod metaMethod = null;

    public MetaMethod getMetaMethod() {
        return this.metaMethod;
    }

    public MethodCallExpression(Expression objectExpression, String method, Expression arguments) {
        this.objectExpression = objectExpression;
        this.method = method;
        this.arguments = arguments;
        this.setType(ClassHelper.DYNAMIC_TYPE);
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        MethodCallExpression answer = new MethodCallExpression(transformer.transform(this.objectExpression), this.method, transformer.transform(this.arguments));
        answer.setSafe(this.safe);
        return answer;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getMethod() {
        return this.method;
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public String getText() {
        return this.objectExpression.getText() + "." + this.method + this.arguments.getText();
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public boolean isSpreadSafe() {
        return this.spreadSafe;
    }

    public void setSpreadSafe(boolean value) {
        this.spreadSafe = value;
    }

    public boolean isImplicitThis() {
        return this.implicitThis;
    }

    public void setImplicitThis(boolean implicitThis) {
        this.implicitThis = implicitThis;
    }

    public String toString() {
        return super.toString() + "[object: " + this.objectExpression + " method: " + this.method + " arguments: " + this.arguments + "]";
    }

    public static boolean isSuperMethodCall(MethodCallExpression call) {
        Expression expression = call.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression varExp = (VariableExpression)expression;
            String variable = varExp.getName();
            return variable.equals("super");
        }
        return false;
    }

    public void setMethod(MetaMethod mmeth) {
        this.metaMethod = mmeth;
        super.setType(ClassHelper.make(mmeth.getReturnType()));
    }
}

