/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class StatementDuration
extends VTITemplate {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private static final String GMT_STRING = " GMT";
    private static final String BEGIN_THREAD_STRING = "[";
    private static final String END_THREAD_STRING = "]";
    private static final String BEGIN_XID_STRING = "= ";
    private static final String END_XID_STRING = ")";
    private static final String BEGIN_EXECUTING_STRING = "Executing prepared";
    private static final String END_EXECUTING_STRING = " :End prepared";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TS", 12, false, 26), EmbedResultSetMetaData.getResultColumnDescriptor("THREADID", 12, false, 80), EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("LCCID", 12, false, 10), EmbedResultSetMetaData.getResultColumnDescriptor("LOGTEXT", 12, true, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("DURATION", 12, false, 10)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);
    private boolean gotFile;
    private InputStreamReader inputFileStreamReader;
    private InputStream inputStream;
    private BufferedReader bufferedReader;
    private String inputFileName;
    private Hashtable hashTable;
    private String line;
    private int gmtIndex;
    private int threadIndex;
    private int xidIndex;
    private int lccidIndex;
    private String[] currentRow;

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        String[] stringArray;
        String[] stringArray2;
        if (!this.gotFile) {
            this.gotFile = true;
            try {
                this.inputFileStreamReader = new InputStreamReader(new FileInputStream(this.inputFileName));
                this.bufferedReader = new BufferedReader(this.inputFileStreamReader, 32768);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException(fileNotFoundException.getMessage());
            }
            this.hashTable = new Hashtable();
        }
        while (true) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (this.line == null) {
                return false;
            }
            this.gmtIndex = this.line.indexOf(GMT_STRING);
            this.threadIndex = this.line.indexOf(BEGIN_THREAD_STRING);
            this.xidIndex = this.line.indexOf(BEGIN_XID_STRING);
            this.lccidIndex = this.line.indexOf(BEGIN_XID_STRING, this.xidIndex + 1);
            if (this.gmtIndex == -1 || this.threadIndex == -1) continue;
            stringArray2 = new String[6];
            int n = 1;
            while (n <= 5) {
                stringArray2[n - 1] = this.setupColumn(n);
                ++n;
            }
            stringArray = this.hashTable.put(stringArray2[3], stringArray2);
            if (stringArray != null) break;
        }
        this.currentRow = stringArray;
        Timestamp timestamp = Timestamp.valueOf(stringArray2[0]);
        long l = ((Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000);
        Timestamp timestamp2 = Timestamp.valueOf(this.currentRow[0]);
        long l2 = ((Date)timestamp2).getTime() + (long)(timestamp2.getNanos() / 1000000);
        this.currentRow[5] = Long.toString(l - l2);
        return true;
    }

    public void close() {
        if (this.bufferedReader != null) {
            try {
                try {
                    this.bufferedReader.close();
                    this.inputFileStreamReader.close();
                }
                catch (IOException iOException) {
                    Object var2_2 = null;
                    this.bufferedReader = null;
                    this.inputFileStreamReader = null;
                }
                Object var2_1 = null;
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.bufferedReader = null;
                this.inputFileStreamReader = null;
                throw throwable;
            }
        }
    }

    public String getString(int n) throws SQLException {
        return this.currentRow[n - 1];
    }

    private String setupColumn(int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.line.substring(0, this.gmtIndex);
            }
            case 2: {
                return this.line.substring(this.threadIndex + 1, this.line.indexOf(END_THREAD_STRING));
            }
            case 3: {
                return this.line.substring(this.xidIndex + 2, this.line.indexOf(END_XID_STRING, this.xidIndex));
            }
            case 4: {
                return this.line.substring(this.lccidIndex + 2, this.line.indexOf(END_XID_STRING, this.lccidIndex));
            }
            case 5: {
                String string;
                if (this.line.indexOf(BEGIN_EXECUTING_STRING) == -1) {
                    string = this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3);
                } else {
                    int n2 = this.line.indexOf(END_EXECUTING_STRING, this.lccidIndex);
                    string = n2 == -1 ? this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3) : this.line.substring(this.line.indexOf(END_XID_STRING, this.lccidIndex) + 3, n2);
                    while (n2 == -1) {
                        try {
                            this.line = this.bufferedReader.readLine();
                        }
                        catch (IOException iOException) {
                            throw new SQLException("Error reading file " + iOException);
                        }
                        n2 = this.line.indexOf(END_EXECUTING_STRING);
                        string = n2 == -1 ? string + this.line : string + this.line.substring(0, n2);
                    }
                }
                string = StringUtil.truncate(string, 32672);
                return string;
            }
        }
        return null;
    }

    public boolean wasNull() {
        return false;
    }

    public StatementDuration() {
        String string = System.getProperty("derby.system.home");
        this.inputFileName = "derby.log";
        if (string != null) {
            this.inputFileName = string + "/" + this.inputFileName;
        }
    }

    public StatementDuration(String string) {
        this.inputFileName = string;
    }
}

