/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;

public class ErrorStringBuilder {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private StringWriter stringWriter;
    private PrintWriter printWriter;
    private PrintWriterGetHeader headerGetter;

    public void append(String string) {
        if (this.headerGetter != null) {
            this.printWriter.print(this.headerGetter.getHeader());
        }
        this.printWriter.print(string);
    }

    public void appendln(String string) {
        if (this.headerGetter != null) {
            this.printWriter.print(this.headerGetter.getHeader());
        }
        this.printWriter.println(string);
    }

    public void stackTrace(Throwable throwable) {
        int n = 0;
        while (throwable != null) {
            if (n > 0) {
                this.printWriter.println("============= begin nested exception, level (" + n + ") ===========");
            }
            throwable.printStackTrace(this.printWriter);
            throwable = throwable instanceof StandardException ? ((StandardException)throwable).getNestedException() : (throwable instanceof ExceptionInInitializerError ? ((ExceptionInInitializerError)throwable).getException() : (throwable instanceof InvocationTargetException ? ((InvocationTargetException)throwable).getTargetException() : (throwable instanceof SQLException ? ((SQLException)throwable).getNextException() : null)));
            if (n > 0) {
                this.printWriter.println("============= end nested exception, level (" + n + ") ===========");
            }
            ++n;
        }
    }

    public void reset() {
        this.stringWriter.getBuffer().setLength(0);
    }

    public StringBuffer get() {
        return this.stringWriter.getBuffer();
    }

    public ErrorStringBuilder(PrintWriterGetHeader printWriterGetHeader) {
        this.headerGetter = printWriterGetHeader;
        this.stringWriter = new StringWriter();
        this.printWriter = new PrintWriter(this.stringWriter);
    }
}

