/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.depend;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;

public class DependableList
implements Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private transient boolean ignoreAdds;
    Vector uuids = new Vector();
    Vector dependableFinders = new Vector();

    public void ignoreAdds(boolean bl) {
        this.ignoreAdds = bl;
    }

    public boolean ignoringAdds() {
        return this.ignoreAdds;
    }

    public void addDependable(Dependable dependable) {
        if (this.ignoreAdds) {
            return;
        }
        this.uuids.addElement(dependable.getObjectID());
        this.dependableFinders.addElement(dependable.getDependableFinder());
    }

    public int size() {
        return this.uuids.size();
    }

    public Dependable dependableAt(int n) throws StandardException {
        Dependable dependable;
        UUID uUID = (UUID)this.uuids.elementAt(n);
        DependableFinder dependableFinder = (DependableFinder)this.dependableFinders.elementAt(n);
        try {
            dependable = dependableFinder.getDependable(uUID);
        }
        catch (SQLException sQLException) {
            throw StandardException.newException("XD003.S", dependableFinder.getClass().getName(), (Object)sQLException.getMessage());
        }
        return dependable;
    }

    public int getTypeFormatId() {
        return 243;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.uuids.addElement(objectInput.readObject());
            this.dependableFinders.addElement(objectInput.readObject());
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.uuids.size();
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeObject(this.uuids.elementAt(n2));
            objectOutput.writeObject(this.dependableFinders.elementAt(n2));
            ++n2;
        }
    }
}

