/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;

public abstract class ConstraintDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider,
Dependent {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public static final int ENABLED = 1;
    public static final int DISABLED = 2;
    public static final int ALL = 3;
    public static final int SYSCONSTRAINTS_STATE_FIELD = 6;
    TableDescriptor table;
    String constraintName;
    boolean deferrable;
    boolean initiallyDeferred;
    boolean isEnabled;
    int[] referencedColumns;
    UUID constraintId;
    SchemaDescriptor schemaDesc;
    ColumnDescriptorList colDL;

    public UUID getTableId() {
        return this.table.getUUID();
    }

    public void setConstraintId(UUID uUID) {
        this.constraintId = uUID;
    }

    public UUID getUUID() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public abstract int getConstraintType();

    public abstract UUID getConglomerateId();

    public String getConstraintText() {
        return null;
    }

    public boolean deferrable() {
        return this.deferrable;
    }

    public boolean initiallyDeferred() {
        return this.initiallyDeferred;
    }

    public int[] getReferencedColumns() {
        return this.referencedColumns;
    }

    public abstract boolean hasBackingIndex();

    public SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDesc;
    }

    public int[] getKeyColumns() {
        return this.getReferencedColumns();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled() {
        this.isEnabled = true;
    }

    public void setDisabled() {
        this.isEnabled = false;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public abstract boolean needsToFire(int var1, int[] var2);

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public ColumnDescriptorList getColumnDescriptors() throws StandardException {
        if (this.colDL == null) {
            DataDictionary dataDictionary = this.getDataDictionary();
            this.colDL = new ColumnDescriptorList();
            int[] nArray = this.getReferencedColumns();
            int n = 0;
            while (n < nArray.length) {
                this.colDL.add(this.table.getColumnDescriptor(nArray[n]));
                ++n;
            }
        }
        return this.colDL;
    }

    public boolean areColumnsComparable(ColumnDescriptorList columnDescriptorList) throws StandardException {
        ColumnDescriptorList columnDescriptorList2 = this.getColumnDescriptors();
        if (columnDescriptorList.size() != columnDescriptorList2.size()) {
            return false;
        }
        int n = columnDescriptorList2.size();
        int n2 = columnDescriptorList.size();
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList2.elementAt(n3);
            ColumnDescriptor columnDescriptor2 = columnDescriptorList.elementAt(n3);
            if (!columnDescriptor.getType().isExactTypeAndLengthMatch(columnDescriptor2.getType())) break;
            ++n3;
        }
        return n3 == n && n3 == n2;
    }

    public boolean columnIntersects(int[] nArray) {
        return ConstraintDescriptor.doColumnsIntersect(this.getReferencedColumns(), nArray);
    }

    static boolean doColumnsIntersect(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return true;
        }
        int n = 0;
        while (n < nArray2.length) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray2[n] == nArray[n2]) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        return "";
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(208);
    }

    public String getObjectName() {
        return this.constraintName;
    }

    public UUID getObjectID() {
        return this.constraintId;
    }

    public String getClassType() {
        return "Constraint";
    }

    public synchronized boolean isValid() {
        return true;
    }

    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            case 20: 
            case 21: 
            case 29: 
            case 30: {
                break;
            }
            default: {
                throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)"CONSTRAINT", (Object)this.constraintName);
            }
        }
    }

    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (n == 21 || n == 20 || n == 29 || n != 30) {
            // empty if block
        }
    }

    public void makeValid(LanguageConnectionContext languageConnectionContext) {
    }

    public String getDescriptorName() {
        return this.constraintName;
    }

    public String getDescriptorType() {
        return "Constraint";
    }

    ConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor tableDescriptor, String string, boolean bl, boolean bl2, int[] nArray, UUID uUID, SchemaDescriptor schemaDescriptor, boolean bl3) {
        super(dataDictionary);
        this.table = tableDescriptor;
        this.constraintName = string;
        this.deferrable = bl;
        this.initiallyDeferred = bl2;
        this.referencedColumns = nArray;
        this.constraintId = uUID;
        this.schemaDesc = schemaDescriptor;
        this.isEnabled = bl3;
    }
}

