/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.types.IndexDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class IndexRowGenerator
implements IndexDescriptor,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    IndexDescriptor id;
    private ExecutionFactory ef;

    public ExecIndexRow getIndexRowTemplate() {
        return this.getExecutionFactory().getIndexableRow(this.id.baseColumnPositions().length + 1);
    }

    public void getIndexRow(ExecRow execRow, RowLocation rowLocation, ExecIndexRow execIndexRow, FormatableBitSet formatableBitSet) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        int n = nArray.length;
        if (formatableBitSet == null) {
            int n2 = 0;
            while (n2 < n) {
                execIndexRow.setColumn(n2 + 1, execRow.getColumn(nArray[n2]));
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray[n3];
                int n5 = 0;
                int n6 = 1;
                while (n6 <= n4) {
                    if (formatableBitSet.get(n6)) {
                        ++n5;
                    }
                    ++n6;
                }
                execIndexRow.setColumn(n3 + 1, execRow.getColumn(n5));
                ++n3;
            }
        }
        execIndexRow.setColumn(n + 1, rowLocation);
    }

    public ExecIndexRow getNullIndexRow(ColumnDescriptorList columnDescriptorList, RowLocation rowLocation) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        ExecIndexRow execIndexRow = this.getIndexRowTemplate();
        int n = 0;
        while (n < nArray.length) {
            DataTypeDescriptor dataTypeDescriptor = columnDescriptorList.elementAt(nArray[n] - 1).getType();
            execIndexRow.setColumn(n + 1, dataTypeDescriptor.getNull());
            ++n;
        }
        execIndexRow.setColumn(n + 1, rowLocation);
        return execIndexRow;
    }

    public boolean indexChanged(int[] nArray) {
        int[] nArray2 = this.id.baseColumnPositions();
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray2.length) {
                if (nArray[n] == nArray2[n2]) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public IndexDescriptor getIndexDescriptor() {
        return this.id;
    }

    public boolean isUnique() {
        return this.id.isUnique();
    }

    public int[] baseColumnPositions() {
        return this.id.baseColumnPositions();
    }

    public Integer getKeyColumnPosition(Integer n) {
        return this.id.getKeyColumnPosition(n);
    }

    public int getKeyColumnPosition(int n) {
        return this.id.getKeyColumnPosition(n);
    }

    public int numberOfOrderedColumns() {
        return this.id.numberOfOrderedColumns();
    }

    public String indexType() {
        return this.id.indexType();
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean isAscending(Integer n) {
        return this.id.isAscending(n);
    }

    public boolean isDescending(Integer n) {
        return this.id.isDescending(n);
    }

    public boolean[] isAscending() {
        return this.id.isAscending();
    }

    public void setBaseColumnPositions(int[] nArray) {
        this.id.setBaseColumnPositions(nArray);
    }

    public void setIsAscending(boolean[] blArray) {
        this.id.setIsAscending(blArray);
    }

    public void setNumberOfOrderedColumns(int n) {
        this.id.setNumberOfOrderedColumns(n);
    }

    public boolean equals(Object object) {
        return this.id.equals(object);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private ExecutionFactory getExecutionFactory() {
        if (this.ef == null) {
            ExecutionContext executionContext = (ExecutionContext)ContextService.getContext("ExecutionContext");
            this.ef = executionContext.getExecutionFactory();
        }
        return this.ef;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (IndexDescriptor)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
    }

    public int getTypeFormatId() {
        return 268;
    }

    public IndexRowGenerator(String string, boolean bl, int[] nArray, boolean[] blArray, int n) {
        this.id = new IndexDescriptorImpl(string, bl, nArray, blArray, n);
    }

    public IndexRowGenerator(IndexDescriptor indexDescriptor) {
        this.id = indexDescriptor;
    }

    public IndexRowGenerator() {
    }
}

