/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationSchemeBase;
import org.apache.derby.impl.jdbc.authentication.JNDIAuthenticationService;

public final class LDAPAuthenticationSchemeImpl
extends JNDIAuthenticationSchemeBase {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private static final String dfltLDAPURL = "ldap://";
    private static final String[] attrDN = new String[]{"dn"};
    private static final String LDAP_SEARCH_BASE = "derby.authentication.ldap.searchBase";
    private static final String LDAP_SEARCH_FILTER = "derby.authentication.ldap.searchFilter";
    private static final String LDAP_SEARCH_AUTH_DN = "derby.authentication.ldap.searchAuthDN";
    private static final String LDAP_SEARCH_AUTH_PW = "derby.authentication.ldap.searchAuthPW";
    private static final String LDAP_LOCAL_USER_DN = "derby.user";
    private static final String LDAP_SEARCH_FILTER_USERNAME = "%USERNAME%";
    private String searchBaseDN;
    private String leftSearchFilter;
    private String rightSearchFilter;
    private boolean useUserPropertyAsDN;
    private String searchAuthDN;
    private String searchAuthPW;

    public boolean authenticateUser(String string, String string2, String string3, Properties properties) throws SQLException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return false;
        }
        try {
            Properties properties2 = (Properties)((Hashtable)this.initDirContextEnv).clone();
            String string4 = null;
            if (this.useUserPropertyAsDN) {
                string4 = this.authenticationService.getProperty("derby.user.");
            }
            if (string4 == null) {
                string4 = this.getDNFromUID(string);
            }
            ((Hashtable)properties2).put("java.naming.security.principal", string4);
            ((Hashtable)properties2).put("java.naming.security.credentials", string2);
            InitialDirContext initialDirContext = new InitialDirContext(properties2);
            return true;
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (NameNotFoundException nameNotFoundException) {
            return false;
        }
        catch (NamingException namingException) {
            NamingException namingException2 = namingException;
            throw JNDIAuthenticationSchemeBase.getLoginSQLException(namingException2);
        }
    }

    protected void setJNDIProviderProperties() {
        String string;
        if (this.initDirContextEnv.getProperty("java.naming.factory.initial") == null) {
            ((Hashtable)this.initDirContextEnv).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        if (this.initDirContextEnv.getProperty("java.naming.provider.url") == null) {
            string = this.authenticationService.getProperty("derby.authentication.server");
            if (string == null) {
                Monitor.logTextMessage("A011", "derby.authentication.server");
                this.providerURL = "ldap:///";
            } else {
                this.providerURL = string.startsWith(dfltLDAPURL) ? string : (string.startsWith("//") ? "ldap:" + string : dfltLDAPURL + string);
            }
            ((Hashtable)this.initDirContextEnv).put("java.naming.provider.url", this.providerURL);
        }
        if (this.initDirContextEnv.getProperty("java.naming.security.authentication") == null) {
            ((Hashtable)this.initDirContextEnv).put("java.naming.security.authentication", "simple");
        }
        this.searchBaseDN = (string = this.authenticationService.getProperty(LDAP_SEARCH_BASE)) != null ? string : "";
        this.searchAuthDN = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_DN);
        this.searchAuthPW = this.authenticationService.getProperty(LDAP_SEARCH_AUTH_PW);
        String string2 = this.authenticationService.getProperty(LDAP_SEARCH_FILTER);
        if (string2 == null) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        } else if (StringUtil.SQLEqualsIgnoreCase(string2, LDAP_LOCAL_USER_DN)) {
            this.leftSearchFilter = "(&(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
            this.useUserPropertyAsDN = true;
        } else if (string2.indexOf(LDAP_SEARCH_FILTER_USERNAME) != -1) {
            this.leftSearchFilter = string2.substring(0, string2.indexOf(LDAP_SEARCH_FILTER_USERNAME));
            this.rightSearchFilter = string2.substring(string2.indexOf(LDAP_SEARCH_FILTER_USERNAME) + LDAP_SEARCH_FILTER_USERNAME.length());
        } else {
            this.leftSearchFilter = "(&(" + string2 + ")" + "(objectClass=inetOrgPerson)(uid=";
            this.rightSearchFilter = "))";
        }
    }

    private String getDNFromUID(String string) throws NamingException {
        Properties properties = null;
        if (this.searchAuthDN != null) {
            properties = (Properties)((Hashtable)this.initDirContextEnv).clone();
            ((Hashtable)properties).put("java.naming.security.principal", this.searchAuthDN);
            ((Hashtable)properties).put("java.naming.security.credentials", this.searchAuthPW);
        } else {
            properties = this.initDirContextEnv;
        }
        InitialDirContext initialDirContext = new InitialDirContext(properties);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(attrDN);
        String string2 = this.leftSearchFilter + string + this.rightSearchFilter;
        NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(this.searchBaseDN, string2, searchControls);
        if (namingEnumeration == null || !namingEnumeration.hasMore()) {
            throw new NameNotFoundException();
        }
        SearchResult searchResult = namingEnumeration.next();
        if (namingEnumeration.hasMore()) {
            throw new NameNotFoundException();
        }
        NameParser nameParser = initialDirContext.getNameParser(this.searchBaseDN);
        Name name = nameParser.parse(this.searchBaseDN);
        if (name == null) {
            throw new NameNotFoundException();
        }
        name.addAll(nameParser.parse(searchResult.getName()));
        return name.toString();
    }

    public LDAPAuthenticationSchemeImpl(JNDIAuthenticationService jNDIAuthenticationService, Properties properties) {
        super(jNDIAuthenticationService, properties);
    }
}

