/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStorablePreparedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;

public class GenericStatement
implements Statement {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private final SchemaDescriptor compilationSchema;
    private final String statementText;
    private int prepareIsolationLevel;
    private GenericPreparedStatement preparedStmt;

    public PreparedStatement prepare(LanguageConnectionContext languageConnectionContext) throws StandardException {
        return this.prepMinion(languageConnectionContext, true, null, null, false);
    }

    /*
     * Unable to fully structure code
     */
    private PreparedStatement prepMinion(LanguageConnectionContext var1_1, boolean var2_2, Object[] var3_3, SchemaDescriptor var4_4, boolean var5_5) throws StandardException {
        var6_6 = 0L;
        var8_7 = 0L;
        var10_8 = 0L;
        var12_9 = 0L;
        var14_10 = 0L;
        var16_11 = null;
        var17_12 = null;
        var18_13 = null;
        if (this.preparedStmt != null && this.preparedStmt.upToDate()) {
            return this.preparedStmt;
        }
        if (var1_1.getOptimizerTrace()) {
            var1_1.setOptimizerTraceOutput(this.getSource() + "\n");
        }
        if ((var6_6 = GenericStatement.getCurrentTimeMillis(var1_1)) != 0L) {
            var16_11 = new Timestamp(var6_6);
        }
        this.prepareIsolationLevel = var1_1.getPrepareIsolationLevel();
        var19_14 = false;
        if (this.preparedStmt == null) {
            if (var2_2) {
                this.preparedStmt = (GenericPreparedStatement)((GenericLanguageConnectionContext)var1_1).lookupStatement(this);
            }
            if (this.preparedStmt == null) {
                this.preparedStmt = new GenericPreparedStatement(this);
            } else {
                var19_14 = true;
            }
        }
        var20_15 = this.preparedStmt;
        synchronized (var20_15) {
            while (true) {
                if (var19_14 && this.preparedStmt.referencesSessionSchema()) {
                    var19_14 = false;
                    this.preparedStmt = new GenericPreparedStatement(this);
                    break;
                }
                if (this.preparedStmt.upToDate()) {
                    var22_17 = this.preparedStmt;
                    var21_18 = null;
                    return var22_17;
                }
                if (!this.preparedStmt.compilingStatement) break;
                try {
                    this.preparedStmt.wait();
                }
                catch (InterruptedException var23_21) {
                    throw StandardException.interrupt(var23_21);
                }
            }
            this.preparedStmt.compilingStatement = true;
            this.preparedStmt.setActivationClass(null);
        }
        try {
            block44: {
                v1 = var23_22 = var1_1.getLogStatementText() != false ? Monitor.getStream() : null;
                if (!this.preparedStmt.isStorable() || var1_1.getStatementDepth() == 0) {
                    var18_13 = var1_1.pushStatementContext(true, this.getSource(), null, false);
                }
                var24_24 = var1_1.pushCompilerContext(this.compilationSchema);
                if (this.prepareIsolationLevel != 0) {
                    var24_24.setScanIsolationLevel(this.prepareIsolationLevel);
                }
                if (var5_5 || var4_4 != null && var4_4.isSystemSchema() && var4_4.equals(this.compilationSchema)) {
                    var24_24.setReliability(0);
                }
                try {
                    block43: {
                        if (var23_22 != null) {
                            var28_25 = var1_1.getTransactionExecute().getActiveStateTxIdString();
                            var23_22.printlnWithHeader("(XID = " + (String)var28_25 + "), " + "(SESSIONID = " + var1_1.getInstanceNumber() + "), " + "(DATABASE = " + var1_1.getDbname() + "), " + "(DRDAID = " + var1_1.getDrdaID() + "), Begin compiling prepared statement: " + this.getSource() + " :End prepared statement");
                        }
                        var28_25 = var24_24.getParser();
                        var24_24.setCurrentDependent(this.preparedStmt);
                        var29_26 = var28_25.parseStatement(this.statementText, var3_3);
                        var8_7 = GenericStatement.getCurrentTimeMillis(var1_1);
                        var30_27 = var1_1.getDataDictionary();
                        var31_28 = var30_27 == null ? 0 : var30_27.startReading(var1_1);
                        try {
                            block42: {
                                var1_1.beginNestedTransaction(true);
                                var29_26 = var29_26.bind();
                                var10_8 = GenericStatement.getCurrentTimeMillis(var1_1);
                                var29_26 = var29_26.optimize();
                                var12_9 = GenericStatement.getCurrentTimeMillis(var1_1);
                                if (var23_22 == null) break block42;
                                var35_29 = var1_1.getTransactionExecute().getActiveStateTxIdString();
                                var23_22.printlnWithHeader("(XID = " + (String)var35_29 + "), " + "(SESSIONID = " + var1_1.getInstanceNumber() + "), " + "(DATABASE = " + var1_1.getDbname() + "), " + "(DRDAID = " + var1_1.getDrdaID() + "), End compiling prepared statement: " + this.getSource() + " :End prepared statement");
                            }
                            var33_32 = null;
                            ** if (var30_27 == null) goto lbl-1000
                        }
                        catch (Throwable var32_35) {
                            var33_33 = null;
                            if (var30_27 != null) {
                                var30_27.doneReading(var31_28, var1_1);
                            }
                            throw var32_35;
                        }
lbl-1000:
                        // 1 sources

                        {
                            var30_27.doneReading(var31_28, var1_1);
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block43;
                            catch (StandardException var35_30) {
                                var1_1.commitNestedTransaction();
                                if (var19_14) {
                                    ((GenericLanguageConnectionContext)var1_1).removeStatement(this);
                                }
                                if (var23_22 != null) {
                                    var36_34 = var1_1.getTransactionExecute().getActiveStateTxIdString();
                                    var23_22.printlnWithHeader("(XID = " + var36_34 + "), " + "(SESSIONID = " + var1_1.getInstanceNumber() + "), " + "(DATABASE = " + var1_1.getDbname() + "), " + "(DRDAID = " + var1_1.getDrdaID() + "), Error compiling prepared statement: " + this.getSource() + " :End prepared statement");
                                }
                                throw var35_30;
                            }
                        }
                    }
                    try {
                        var35_29 = var29_26.generate(this.preparedStmt.getByteCodeSaver());
                        var14_10 = GenericStatement.getCurrentTimeMillis(var1_1);
                        if (var14_10 != 0L) {
                            var17_12 = new Timestamp(var14_10);
                        }
                        this.preparedStmt.setConstantAction(var29_26.makeConstantAction());
                        this.preparedStmt.setSavedObjects(var24_24.getSavedObjects());
                        this.preparedStmt.setActivationClass((GeneratedClass)var35_29);
                        this.preparedStmt.setParams(var24_24.getParams());
                        this.preparedStmt.setNeedsSavepoint(var29_26.needsSavepoint());
                        this.preparedStmt.setCursorInfo((CursorInfo)var24_24.getCursorInfo());
                        this.preparedStmt.setIsAtomic(var29_26.isAtomic());
                        this.preparedStmt.setExecuteStatementNameAndSchema(var29_26.executeStatementName(), var29_26.executeSchemaName());
                        this.preparedStmt.setSPSName(var29_26.getSPSName());
                        if (this.preparedStmt.completeCompile(var29_26) && var19_14) {
                            ((GenericLanguageConnectionContext)var1_1).removeStatement(this);
                        }
                        this.preparedStmt.setCompileTimeWarnings(var24_24.getWarnings());
                    }
                    catch (StandardException var35_31) {
                        var1_1.commitNestedTransaction();
                        if (var19_14) {
                            ((GenericLanguageConnectionContext)var1_1).removeStatement(this);
                        }
                        throw var35_31;
                    }
                    if (!var1_1.getRunTimeStatisticsMode()) break block44;
                    this.preparedStmt.setCompileTimeMillis(var8_7 - var6_6, var10_8 - var8_7, var12_9 - var10_8, var14_10 - var12_9, GenericStatement.getElapsedTimeMillis(var6_6), var16_11, var17_12);
                }
                catch (Throwable var25_38) {
                    var26_37 = null;
                    var1_1.popCompilerContext(var24_24);
                    throw var25_38;
                }
            }
            var26_36 = null;
            var1_1.popCompilerContext(var24_24);
            var21_19 = null;
            var23_22 = this.preparedStmt;
        }
        catch (Throwable var20_16) {
            var21_20 = null;
            var23_23 = this.preparedStmt;
            synchronized (var23_23) {
                this.preparedStmt.compilingStatement = false;
                this.preparedStmt.notifyAll();
            }
            throw var20_16;
        }
        synchronized (var23_22) {
            this.preparedStmt.compilingStatement = false;
            this.preparedStmt.notifyAll();
        }
        var1_1.commitNestedTransaction();
        if (var18_13 != null) {
            var1_1.popStatementContext(var18_13, null);
        }
        return this.preparedStmt;
    }

    public PreparedStatement prepareStorable(LanguageConnectionContext languageConnectionContext, PreparedStatement preparedStatement, Object[] objectArray, SchemaDescriptor schemaDescriptor, boolean bl) throws StandardException {
        if (preparedStatement == null) {
            preparedStatement = new GenericStorablePreparedStatement(this);
        } else {
            ((GenericPreparedStatement)preparedStatement).statement = this;
        }
        this.preparedStmt = (GenericPreparedStatement)preparedStatement;
        return this.prepMinion(languageConnectionContext, false, objectArray, schemaDescriptor, bl);
    }

    public String getSource() {
        return this.statementText;
    }

    public boolean getUnicode() {
        return true;
    }

    public String getCompilationSchema() {
        return this.compilationSchema.getDescriptorName();
    }

    private static long getCurrentTimeMillis(LanguageConnectionContext languageConnectionContext) {
        if (languageConnectionContext.getStatisticsTiming()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private static long getElapsedTimeMillis(long l) {
        if (l != 0L) {
            return System.currentTimeMillis() - l;
        }
        return 0L;
    }

    public boolean equals(Object object) {
        if (object instanceof GenericStatement) {
            GenericStatement genericStatement = (GenericStatement)object;
            return this.statementText.equals(genericStatement.statementText) && this.compilationSchema.equals(genericStatement.compilationSchema) && this.prepareIsolationLevel == genericStatement.prepareIsolationLevel;
        }
        return false;
    }

    public int hashCode() {
        return this.statementText.hashCode();
    }

    public GenericStatement(SchemaDescriptor schemaDescriptor, String string) {
        this.compilationSchema = schemaDescriptor;
        this.statementText = string;
    }
}

