/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DDdependableFinder;

public class DDColumnDependableFinder
extends DDdependableFinder {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2001, 2004.";
    private byte[] columnBitMap;

    public byte[] getColumnBitMap() {
        return this.columnBitMap;
    }

    public void setColumnBitMap(byte[] byArray) {
        this.columnBitMap = byArray;
    }

    protected Dependable getDependable(DataDictionary dataDictionary, UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(uUID);
        if (tableDescriptor != null) {
            tableDescriptor.setReferencedColumnMap(new FormatableBitSet(this.columnBitMap));
        }
        return tableDescriptor;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.columnBitMap = (byte[])formatableHashtable.get("columnBitMap");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("columnBitMap", this.columnBitMap);
        objectOutput.writeObject(formatableHashtable);
    }

    public DDColumnDependableFinder(int n) {
        super(n);
    }

    public DDColumnDependableFinder(int n, byte[] byArray) {
        super(n);
        this.columnBitMap = byArray;
    }
}

