/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class BinaryOperatorNode
extends ValueNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int TIMES = 3;
    public static final int DIVIDE = 4;
    public static final int CONCATENATE = 5;
    public static final int EQ = 6;
    public static final int NE = 7;
    public static final int GT = 8;
    public static final int GE = 9;
    public static final int LT = 10;
    public static final int LE = 11;
    public static final int AND = 12;
    public static final int OR = 13;
    public static final int LIKE = 14;
    String operator;
    String methodName;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String leftInterfaceType;
    String rightInterfaceType;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        this.leftOperand = (ValueNode)object;
        this.rightOperand = (ValueNode)object2;
        this.operator = (String)object3;
        this.methodName = (String)object4;
        this.leftInterfaceType = (String)object5;
        this.rightInterfaceType = (String)object6;
    }

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.leftOperand = (ValueNode)object;
        this.rightOperand = (ValueNode)object2;
        this.leftInterfaceType = (String)object3;
        this.rightInterfaceType = (String)object4;
    }

    public String toString() {
        return "";
    }

    void setOperator(String string) {
        this.operator = string;
    }

    void setMethodName(String string) {
        this.methodName = string;
    }

    public void setLeftRightInterfaceType(String string) {
        this.leftInterfaceType = string;
        this.rightInterfaceType = string;
    }

    public void setClause(int n) {
        super.setClause(n);
        this.leftOperand.setClause(n);
        this.rightOperand.setClause(n);
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, vector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, vector);
        if (this.leftOperand.isParameterNode()) {
            if (this.rightOperand.isParameterNode()) {
                throw StandardException.newException("42X35", this.operator);
            }
            ((ParameterNode)this.leftOperand).setDescriptor(this.rightOperand.getTypeServices());
        }
        if (this.rightOperand.isParameterNode()) {
            ((ParameterNode)this.rightOperand).setDescriptor(this.leftOperand.getTypeServices());
        }
        return this.genSQLJavaSQLTree();
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (!typeId2.systemBuiltIn()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (!(typeId = this.rightOperand.getTypeId()).systemBuiltIn()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        boolean bl;
        String string;
        if (this.leftOperand.getTypeId().typePrecedence() > this.rightOperand.getTypeId().typePrecedence()) {
            this.receiver = this.leftOperand;
            string = this.getReceiverInterfaceName();
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.putField(localField);
            methodBuilder.cast(string);
            methodBuilder.getField(localField);
            methodBuilder.cast(this.leftInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.rightInterfaceType);
        } else {
            this.receiver = this.rightOperand;
            string = this.getReceiverInterfaceName();
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, this.rightInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.putField(localField);
            methodBuilder.cast(string);
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast(this.leftInterfaceType);
            methodBuilder.getField(localField);
            methodBuilder.cast(this.rightInterfaceType);
        }
        String string2 = this.getTypeCompiler().interfaceName();
        boolean bl2 = bl = !this.getTypeId().isBooleanTypeId();
        if (bl) {
            int n;
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
            methodBuilder.getField(localField);
            this.initializeResultField(expressionClassBuilder, methodBuilder, localField);
            if (this.dataTypeServices != null && ((n = this.dataTypeServices.getJDBCTypeId()) == 3 || n == 2) && this.operator.equals("/")) {
                methodBuilder.push(this.dataTypeServices.getScale());
                methodBuilder.callMethod((short)185, string, this.methodName, string2, 4);
            } else {
                methodBuilder.callMethod((short)185, string, this.methodName, string2, 3);
            }
            if (this.getTypeId().variableLength() && this.getTypeId().isNumericTypeId()) {
                methodBuilder.push(this.getTypeServices().getPrecision());
                methodBuilder.push(this.getTypeServices().getScale());
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "org.apache.derby.iapi.types.DataValueDescriptor", 3);
            }
            methodBuilder.putField(localField);
        } else {
            methodBuilder.callMethod((short)185, string, this.methodName, string2, 2);
        }
    }

    protected void initializeResultField(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, LocalField localField) {
    }

    public void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode valueNode) {
        this.rightOperand = valueNode;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.leftOperand.categorize(jBitSet, bl);
        bl2 = this.rightOperand.categorize(jBitSet, bl) && bl2;
        return bl2;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.leftOperand.isConstantExpression() && this.rightOperand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.leftOperand.constantExpression(predicateList) && this.rightOperand.constantExpression(predicateList);
    }

    public String getReceiverInterfaceName() throws StandardException {
        return this.receiver.getTypeCompiler().interfaceName();
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = this.leftOperand.getOrderableVariantType();
        int n2 = this.rightOperand.getOrderableVariantType();
        return Math.min(n, n2);
    }

    void swapOperands() {
        String string = this.leftInterfaceType;
        ValueNode valueNode = this.leftOperand;
        this.leftOperand = this.rightOperand;
        this.rightOperand = valueNode;
        this.leftInterfaceType = this.rightInterfaceType;
        this.rightInterfaceType = string;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.leftOperand != null && !visitor.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null && !visitor.stopTraversal()) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(visitor);
        }
        return visitable;
    }
}

