/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RIBulkChecker;

public abstract class ConstraintConstantAction
extends DDLSingleTableConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    protected String constraintName;
    protected int constraintType;
    protected String tableName;
    protected String schemaName;
    protected UUID schemaId;
    protected IndexConstantAction indexAction;

    public int getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public IndexConstantAction getIndexAction() {
        return this.indexAction;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void validateFKConstraint(TransactionController transactionController, DataDictionary dataDictionary, ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor, ExecRow execRow) throws StandardException {
        GroupFetchScanController groupFetchScanController;
        GenericScanController genericScanController;
        block11: {
            block9: {
                block10: {
                    genericScanController = null;
                    groupFetchScanController = transactionController.openGroupFetchScan(foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, TransactionController.MODE_TABLE, TransactionController.ISOLATION_READ_COMMITTED, null, null, 1, null, null, -1);
                    try {
                        if (!groupFetchScanController.next()) {
                            groupFetchScanController.close();
                            Object var8_7 = null;
                            if (groupFetchScanController == null) break block9;
                            break block10;
                        }
                        groupFetchScanController.reopenScan(null, 1, null, null, -1);
                        genericScanController = transactionController.openGroupFetchScan(referencedKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber(), false, 0, TransactionController.MODE_RECORD, TransactionController.ISOLATION_READ_COMMITTED, null, null, 1, null, null, -1);
                        RIBulkChecker rIBulkChecker = new RIBulkChecker((GroupFetchScanController)genericScanController, groupFetchScanController, execRow, true, null, null);
                        int n = rIBulkChecker.doCheck();
                        if (n > 0) {
                            StandardException standardException = StandardException.newException("X0Y45.S", foreignKeyConstraintDescriptor.getConstraintName(), (Object)foreignKeyConstraintDescriptor.getTableDescriptor().getName());
                            throw standardException;
                        }
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (groupFetchScanController != null) {
                            groupFetchScanController.close();
                            groupFetchScanController = null;
                        }
                        if (genericScanController != null) {
                            genericScanController.close();
                            genericScanController = null;
                        }
                        throw throwable;
                    }
                }
                groupFetchScanController.close();
                groupFetchScanController = null;
            }
            if (genericScanController != null) {
                genericScanController.close();
                return;
            }
            return;
        }
        Object var8_8 = null;
        if (groupFetchScanController != null) {
            groupFetchScanController.close();
            groupFetchScanController = null;
        }
        if (genericScanController != null) {
            genericScanController.close();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean validateConstraint(String string, String string2, TableDescriptor tableDescriptor, LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        ResultSet resultSet;
        block3: {
            boolean bl2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT COUNT(*) FROM ");
            stringBuffer.append(tableDescriptor.getQualifiedName());
            stringBuffer.append(" WHERE NOT(");
            stringBuffer.append(string2);
            stringBuffer.append(")");
            resultSet = null;
            try {
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(tableDescriptor.getSchemaDescriptor(), stringBuffer.toString());
                resultSet = preparedStatement.execute(languageConnectionContext, false);
                ExecRow execRow = resultSet.getNextRow();
                DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
                Number number = (Number)((NumberDataValue)execRow.getRowArray()[0]).getObject();
                if (number == null || number.longValue() == 0L) break block3;
                if (bl) {
                    throw StandardException.newException("X0Y59.S", string, (Object)tableDescriptor.getQualifiedName(), (Object)number.toString());
                }
                bl2 = false;
                Object var8_12 = null;
                if (resultSet == null) return bl2;
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return bl2;
        }
        Object var8_13 = null;
        if (resultSet == null) return true;
        resultSet.close();
        return true;
    }

    public abstract void executeConstantAction(Activation var1) throws StandardException;

    ConstraintConstantAction(String string, int n, String string2, UUID uUID, String string3, IndexConstantAction indexConstantAction) {
        super(uUID);
        this.constraintName = string;
        this.constraintType = n;
        this.tableName = string2;
        this.indexAction = indexConstantAction;
        this.schemaName = string3;
    }
}

