/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class ValueRow
implements ExecRow,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private DataValueDescriptor[] column;
    private int ncols;

    public int nColumns() {
        return this.ncols;
    }

    public void getNewObjectArray() {
        this.column = new DataValueDescriptor[this.ncols];
    }

    public DataValueDescriptor getColumn(int n) {
        if (n <= this.column.length) {
            return this.column[n - 1];
        }
        return null;
    }

    public void setColumn(int n, DataValueDescriptor dataValueDescriptor) {
        if (n > this.column.length) {
            this.realloc(n);
        }
        this.column[n - 1] = dataValueDescriptor;
    }

    public ExecRow getClone() {
        return this.getClone(null);
    }

    public ExecRow getClone(FormatableBitSet formatableBitSet) {
        int n = this.column.length;
        ExecRow execRow = this.cloneMe();
        int n2 = 0;
        while (n2 < n) {
            if (formatableBitSet != null && !formatableBitSet.get(n2 + 1)) {
                execRow.setColumn(n2 + 1, this.column[n2]);
            } else if (this.column[n2] != null) {
                execRow.setColumn(n2 + 1, this.column[n2].getClone());
            }
            ++n2;
        }
        return execRow;
    }

    public ExecRow getNewNullRow() {
        int n = this.column.length;
        ExecRow execRow = this.cloneMe();
        int n2 = 0;
        while (n2 < n) {
            if (this.column[n2] != null) {
                if (this.column[n2] instanceof RowLocation) {
                    execRow.setColumn(n2 + 1, this.column[n2].getClone());
                } else {
                    execRow.setColumn(n2 + 1, this.column[n2].getNewNull());
                }
            }
            ++n2;
        }
        return execRow;
    }

    ExecRow cloneMe() {
        return new ValueRow(this.ncols);
    }

    public final DataValueDescriptor cloneColumn(int n) {
        return this.column[n - 1].getClone();
    }

    public String toString() {
        String string = "{ ";
        int n = 0;
        while (n < this.column.length) {
            string = this.column[n] == null ? string + "null" : string + this.column[n].toString();
            if (n < this.column.length - 1) {
                string = string + ", ";
            }
            ++n;
        }
        string = string + " }";
        return string;
    }

    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    public DataValueDescriptor[] getRowArrayClone() {
        int n = this.column.length;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        int n2 = 0;
        while (n2 < n) {
            if (this.column[n2] != null) {
                dataValueDescriptorArray[n2] = this.column[n2].getClone();
            }
            ++n2;
        }
        return dataValueDescriptorArray;
    }

    public void setRowArray(DataValueDescriptor[] dataValueDescriptorArray) {
        this.column = dataValueDescriptorArray;
    }

    public void setRowArray(Storable[] storableArray) {
        if (storableArray instanceof DataValueDescriptor[]) {
            this.column = (DataValueDescriptor[])storableArray;
            return;
        }
        if (this.column == null || this.column.length != storableArray.length) {
            this.column = new DataValueDescriptor[storableArray.length];
        }
        System.arraycopy(storableArray, 0, this.column, 0, this.column.length);
    }

    protected void realloc(int n) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        System.arraycopy(this.column, 0, dataValueDescriptorArray, 0, this.column.length);
        this.column = dataValueDescriptorArray;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.column = new DataValueDescriptor[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.column);
        this.ncols = this.column.length;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ArrayUtil.writeArrayLength(objectOutput, this.column);
        ArrayUtil.writeArrayItems(objectOutput, this.column);
    }

    public int getTypeFormatId() {
        return 237;
    }

    public ValueRow() {
    }

    public ValueRow(int n) {
        this.column = new DataValueDescriptor[n];
        this.ncols = n;
    }
}

