/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.index.B2I;

public class B2IFactory
implements ConglomerateFactory,
ModuleControl {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final String IMPLEMENTATIONID = "BTREE";
    private static final String FORMATUUIDSTRING = "C6CEEEF0-DAD3-11d0-BB01-0060973F0942";
    private UUID formatUUID;

    public Properties defaultProperties() {
        return new Properties();
    }

    public boolean supportsImplementation(String string) {
        return string.equals(IMPLEMENTATIONID);
    }

    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    public boolean supportsFormat(UUID uUID) {
        return uUID.equals(this.formatUUID);
    }

    public UUID primaryFormat() {
        return this.formatUUID;
    }

    public int getConglomerateFactoryId() {
        return 1;
    }

    public Conglomerate createConglomerate(TransactionManager transactionManager, int n, long l, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, Properties properties, int n2) throws StandardException {
        B2I b2I = new B2I();
        b2I.create(transactionManager, n, l, dataValueDescriptorArray, columnOrderingArray, properties, n2);
        return b2I;
    }

    public Conglomerate readConglomerate(TransactionManager transactionManager, ContainerKey containerKey) throws StandardException {
        B2I b2I = null;
        ContainerHandle containerHandle = null;
        ControlRow controlRow = null;
        try {
            containerHandle = transactionManager.getRawStoreXact().openContainer(containerKey, null, 8);
            if (containerHandle == null) {
                throw StandardException.newException("XSAI2.S", new Long(containerKey.getContainerId()));
            }
            controlRow = ControlRow.Get(containerHandle, 1L);
            b2I = (B2I)controlRow.getConglom(388);
        }
        finally {
            Object var7_6 = null;
            if (controlRow != null) {
                controlRow.release();
            }
            if (containerHandle != null) {
                containerHandle.close();
            }
        }
        return b2I;
    }

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.access.Conglomerate.type");
        if (string == null) {
            return false;
        }
        return this.supportsImplementation(string);
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uUIDFactory.recreateUUID(FORMATUUIDSTRING);
    }

    public void stop() {
    }
}

