/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class RAFContainer
extends FileContainer
implements PrivilegedExceptionAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;

    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    public Cacheable setIdentity(Object object) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            TempRAFContainer tempRAFContainer = new TempRAFContainer(this.dataFactory);
            return tempRAFContainer.setIdent(containerKey);
        }
        return this.setIdent(containerKey);
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            TempRAFContainer tempRAFContainer = new TempRAFContainer(this.dataFactory);
            return tempRAFContainer.createIdent(containerKey, object2);
        }
        return this.createIdent(containerKey, object2);
    }

    protected void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
        this.pageCache.discard(this.identity);
        this.stubbify(logInstant);
    }

    protected final void closeContainer() {
        if (this.fileData != null) {
            try {
                try {
                    this.fileData.close();
                }
                catch (IOException iOException) {
                    Object var2_2 = null;
                    this.fileData = null;
                }
                Object var2_1 = null;
                this.fileData = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fileData = null;
                throw throwable;
            }
        }
    }

    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(l2);
            this.fileData.readFully(byArray, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                Object var6_5 = null;
                return;
            }
            if (l == 0L) {
                this.writeHeader(byArray);
            }
            long l2 = l * (long)this.pageSize;
            try {
                this.fileData.seek(l2);
                if (this.fileData.getFilePointer() != l2) {
                    this.padFile(this.fileData, l2);
                }
                byte[] byArray2 = this.dataFactory.databaseEncrypted() && l != 0L ? this.encryptPage(byArray, this.pageSize) : byArray;
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray2, 0, this.pageSize);
                }
                finally {
                    Object var11_10 = null;
                    this.dataFactory.writeFinished();
                }
            }
            catch (IOException iOException) {
                if (!this.padFile(this.fileData, l2)) {
                    throw iOException;
                }
                this.fileData.seek(l2);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray, 0, this.pageSize);
                }
                finally {
                    Object var11_12 = null;
                    this.dataFactory.writeFinished();
                }
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.sync(false);
                }
                finally {
                    Object var10_16 = null;
                    this.dataFactory.writeFinished();
                }
            } else {
                this.needsSync = true;
            }
        }
    }

    private boolean padFile(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        long l2 = storageRandomAccessFile.length();
        if (l2 >= l) {
            return false;
        }
        byte[] byArray = new byte[this.pageSize];
        storageRandomAccessFile.seek(l2);
        while (l2 < l) {
            this.dataFactory.writeInProgress();
            try {
                long l3 = l - l2;
                if (l3 > (long)this.pageSize) {
                    l3 = this.pageSize;
                }
                storageRandomAccessFile.write(byArray, 0, (int)l3);
            }
            finally {
                Object var8_5 = null;
                this.dataFactory.writeFinished();
            }
            l2 += (long)this.pageSize;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clean(boolean bl) throws StandardException {
        boolean bl2 = false;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            block11: {
                if (this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                while (true) {
                    if (!this.preDirty) {
                        if (!bl2 || !this.getCommittedDropState()) break;
                        break block11;
                    }
                    bl2 = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
                if (bl) return;
                if (!this.isDirty()) return;
                try {
                    this.writeRAFHeader(this.fileData, false, true);
                    this.clearDirty();
                }
                catch (IOException iOException) {
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this));
                }
                return;
            }
            this.clearDirty();
            return;
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    protected int preAllocate(long l, int n) {
        int n2 = this.doPreAllocatePages(l, n);
        if (n2 > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                block13: {
                    boolean bl = false;
                    try {
                        try {
                            this.dataFactory.writeInProgress();
                            bl = true;
                            this.fileData.sync(false);
                        }
                        catch (IOException iOException) {
                            n2 = 0;
                            Object var10_7 = null;
                            if (bl) {
                                this.dataFactory.writeFinished();
                            }
                            break block13;
                        }
                        catch (StandardException standardException) {
                            n2 = 0;
                            Object var10_8 = null;
                            if (bl) {
                                this.dataFactory.writeFinished();
                            }
                        }
                        Object var10_6 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (bl) {
                            this.dataFactory.writeFinished();
                        }
                        throw throwable;
                    }
                }
            }
        }
        return n2;
    }

    private void writeRAFHeader(StorageRandomAccessFile storageRandomAccessFile, boolean bl, boolean bl2) throws IOException, StandardException {
        byte[] byArray;
        if (bl) {
            byArray = this.getEmbryonicPage(null);
        } else {
            storageRandomAccessFile.seek(0L);
            byArray = this.getEmbryonicPage(storageRandomAccessFile);
        }
        storageRandomAccessFile.seek(0L);
        this.writeHeader(storageRandomAccessFile, bl, byArray);
        if (bl) {
            this.padFile(storageRandomAccessFile, this.pageSize);
        }
        if (bl2) {
            this.dataFactory.writeInProgress();
            try {
                storageRandomAccessFile.sync(false);
            }
            finally {
                Object var6_5 = null;
                this.dataFactory.writeFinished();
            }
        }
        byArray = null;
    }

    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    protected synchronized StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = containerKey;
        this.actionStub = bl;
        this.actionErrorOK = bl2;
        this.actionTryAlternatePath = bl3;
        try {
            try {
                StorageFile storageFile = (StorageFile)AccessController.doPrivileged(this);
                Object var6_6 = null;
                this.actionIdentity = null;
                return storageFile;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    protected StorageFile privGetFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = this.dataFactory.getContainerPath(containerKey, bl);
        if (!storageFile2.exists() && bl3) {
            storageFile2 = this.dataFactory.getAlternateContainerPath(containerKey, bl);
        }
        if (!storageFile2.exists() && !(storageFile = storageFile2.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!storageFile.exists() && !storageFile.mkdirs()) {
                    if (bl2) {
                        StorageFile storageFile3 = null;
                        Object var8_9 = null;
                        return storageFile3;
                    }
                    throw StandardException.newException("XSDF3.S", storageFile);
                }
            }
        }
        return storageFile2;
    }

    protected synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 2;
        this.actionIdentity = containerKey;
        try {
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
            Object var3_2 = null;
            this.actionIdentity = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    protected synchronized boolean removeFile(StorageFile storageFile) throws SecurityException, StandardException {
        this.actionCode = 3;
        this.actionFile = storageFile;
        try {
            try {
                boolean bl = AccessController.doPrivileged(this) != null;
                Object var3_3 = null;
                this.actionFile = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.actionFile = null;
            throw throwable;
        }
    }

    private boolean privRemoveFile(StorageFile storageFile) throws StandardException {
        this.closeContainer();
        this.dataFactory.writeInProgress();
        try {
            if (storageFile.exists()) {
                boolean bl = storageFile.delete();
                Object var3_3 = null;
                this.dataFactory.writeFinished();
                return bl;
            }
            Object var3_4 = null;
            this.dataFactory.writeFinished();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.dataFactory.writeFinished();
            throw throwable;
        }
        return true;
    }

    protected synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = containerKey;
        try {
            try {
                boolean bl = AccessController.doPrivileged(this) != null;
                Object var3_3 = null;
                this.actionIdentity = null;
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.actionIdentity = null;
            throw throwable;
        }
    }

    protected synchronized void stubbify(LogInstant logInstant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = logInstant;
        this.actionCode = 5;
        try {
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (StandardException)privilegedActionException.getException();
            }
            Object var3_2 = null;
            this.actionIdentity = null;
            this.actionInstant = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.actionIdentity = null;
            this.actionInstant = null;
            throw throwable;
        }
    }

    public Object run() throws StandardException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, false);
                try {
                    if (storageFile.exists()) {
                        throw StandardException.newException("XSDF0.S", storageFile);
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF1.S", securityException, (Object)storageFile);
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = storageFile.getRandomAccessFile("rw");
                    }
                    finally {
                        Object var3_10 = null;
                        this.dataFactory.writeFinished();
                    }
                    this.writeRAFHeader(this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF1.S", securityException, (Object)storageFile);
                }
                catch (IOException iOException) {
                    boolean bl;
                    try {
                        bl = this.privRemoveFile(storageFile);
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, (Object)securityException);
                    }
                    if (!bl) {
                        throw StandardException.newException("XSDF2.S", iOException, (Object)storageFile, null);
                    }
                    throw StandardException.newException("XSDF1.S", iOException, (Object)storageFile);
                }
                this.canUpdate = true;
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean bl = false;
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                if (storageFile == null) {
                    return null;
                }
                try {
                    if (!storageFile.exists()) {
                        storageFile = this.privGetFileName(this.actionIdentity, true, true, true);
                        if (!storageFile.exists()) {
                            return null;
                        }
                        bl = true;
                    }
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDA4.S", securityException);
                }
                this.canUpdate = false;
                try {
                    if (!this.dataFactory.isReadOnly() && storageFile.canWrite()) {
                        this.canUpdate = true;
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.fileData.seek(0L);
                    this.readHeader(this.fileData);
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this, (Object)iOException));
                    }
                    StorageFile storageFile2 = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (storageFile2.exists()) {
                        try {
                            this.privRemoveFile(storageFile);
                            this.fileData = storageFile2.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.fileData);
                        }
                        catch (IOException iOException2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException2, (Object)this, (Object)iOException2));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException("XSDG3.D", iOException, (Object)this, (Object)iOException));
                }
                return this;
            }
            case 5: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile storageFile3 = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (!storageFile3.exists()) {
                        storageRandomAccessFile = storageFile3.getRandomAccessFile("rw");
                        this.writeRAFHeader(storageRandomAccessFile, true, true);
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(storageFile);
                }
                catch (SecurityException securityException) {
                    throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)securityException);
                }
                catch (IOException iOException) {
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageFile3.delete();
                            storageRandomAccessFile = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException iOException3) {
                        throw StandardException.newException("XSDF4.S", iOException3, (Object)storageFile, (Object)iOException);
                    }
                    catch (SecurityException securityException) {
                        throw StandardException.newException("XSDF4.S", securityException, (Object)storageFile, (Object)storageFile3);
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(storageFile3, this.actionInstant, this.getIdentity());
                return null;
            }
        }
        return null;
    }

    protected RAFContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }
}

