/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;

public class FlushedScan
implements StreamLogScan {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    static final int LOG_REC_LEN_BYTE_LENGTH = 4;
    private StorageRandomAccessFile scan;
    LogToFile logFactory;
    boolean open;
    long currentLogFileNumber;
    long currentLogFileFirstUnflushedPosition;
    long currentInstant;
    long firstUnflushed = -1L;
    long firstUnflushedFileNumber;
    long firstUnflushedFilePosition;
    int nextRecordLength;
    boolean readNextRecordLength;

    public LogRecord getNextRecord(ArrayInputStream arrayInputStream, TransactionId transactionId, int n) throws StandardException {
        try {
            LogRecord logRecord;
            boolean bl;
            int n2 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
            if (transactionId != null) {
                n2 += LogRecord.maxTransactionIdStoredSize(transactionId);
            }
            do {
                int n3;
                if (!this.open || !this.positionToNextRecord()) {
                    return null;
                }
                logRecord = null;
                bl = true;
                int n4 = -1;
                this.currentInstant = this.scan.readLong();
                byte[] byArray = arrayInputStream.getData();
                if (byArray.length < this.nextRecordLength) {
                    byArray = new byte[this.nextRecordLength];
                    arrayInputStream.setData(byArray);
                }
                if (this.logFactory.databaseEncrypted()) {
                    this.scan.readFully(byArray, 0, this.nextRecordLength);
                    n3 = this.logFactory.decrypt(byArray, 0, this.nextRecordLength, byArray, 0);
                    arrayInputStream.setLimit(0, n3);
                } else if (n == 0 && transactionId == null) {
                    this.scan.readFully(byArray, 0, this.nextRecordLength);
                    arrayInputStream.setLimit(0, this.nextRecordLength);
                } else {
                    n4 = this.nextRecordLength > n2 ? n2 : this.nextRecordLength;
                    this.scan.readFully(byArray, 0, n4);
                    arrayInputStream.setLimit(0, n4);
                }
                logRecord = (LogRecord)arrayInputStream.readObject();
                if (n != 0 || transactionId != null) {
                    TransactionId transactionId2;
                    if (n != 0 && (n & logRecord.group()) == 0) {
                        bl = false;
                    }
                    if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                        bl = false;
                    }
                    if (bl && !this.logFactory.databaseEncrypted() && n4 < this.nextRecordLength) {
                        n3 = arrayInputStream.getPosition();
                        this.scan.readFully(byArray, n4, this.nextRecordLength - n4);
                        arrayInputStream.setLimit(0, this.nextRecordLength);
                        arrayInputStream.setPosition(n3);
                    }
                }
                if (bl || this.logFactory.databaseEncrypted()) {
                    int n5 = this.scan.readInt();
                    continue;
                }
                long l = LogCounter.getLogFilePosition(this.currentInstant) + (long)this.nextRecordLength + 16L;
                this.scan.seek(l);
            } while (!bl);
            return logRecord;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
        }
        catch (IOException iOException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
    }

    public void resetPosition(LogInstant logInstant) throws IOException {
    }

    public long getLogRecordEnd() {
        return 0L;
    }

    public boolean isLogEndFuzzy() {
        return false;
    }

    public long getInstant() {
        return this.currentInstant;
    }

    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.currentInstant = 0L;
        this.open = false;
    }

    private void setFirstUnflushed() throws StandardException, IOException {
        LogInstant logInstant = this.logFactory.getFirstUnflushedInstant();
        this.firstUnflushed = ((LogCounter)logInstant).getValueAsLong();
        this.firstUnflushedFileNumber = LogCounter.getLogFileNumber(this.firstUnflushed);
        this.firstUnflushedFilePosition = LogCounter.getLogFilePosition(this.firstUnflushed);
        this.setCurrentLogFileFirstUnflushedPosition();
    }

    private void setCurrentLogFileFirstUnflushedPosition() throws IOException {
        if (this.currentLogFileNumber == this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.firstUnflushedFilePosition;
        } else if (this.currentLogFileNumber < this.firstUnflushedFileNumber) {
            this.currentLogFileFirstUnflushedPosition = this.scan.length();
        } else {
            throw new IOException(MessageService.getTextMessage("L014"));
        }
    }

    private void switchLogFile() throws StandardException {
        try {
            this.readNextRecordLength = false;
            this.scan.close();
            this.scan = null;
            this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
            this.setCurrentLogFileFirstUnflushedPosition();
        }
        catch (IOException iOException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
    }

    private boolean currentLogFileHasUnflushedRecord() throws IOException {
        long l = this.scan.getFilePointer();
        if (!this.readNextRecordLength) {
            if (l + 4L > this.currentLogFileFirstUnflushedPosition) {
                return false;
            }
            this.nextRecordLength = this.scan.readInt();
            l += 4L;
            this.readNextRecordLength = true;
        }
        if (this.nextRecordLength == 0) {
            return false;
        }
        int n = this.nextRecordLength + 4;
        if (l + (long)n > this.currentLogFileFirstUnflushedPosition) {
            return false;
        }
        this.readNextRecordLength = false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean positionToNextRecord() throws StandardException, IOException {
        if (this.currentLogFileHasUnflushedRecord()) {
            return true;
        }
        this.setFirstUnflushed();
        if (!this.currentLogFileHasUnflushedRecord()) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            this.switchLogFile();
            if (!this.currentLogFileHasUnflushedRecord()) continue;
            return true;
lbl9:
            // 2 sources

            ** while (this.currentLogFileNumber < this.firstUnflushedFileNumber)
        }
lbl10:
        // 1 sources

        this.currentInstant = 0L;
        return false;
    }

    public FlushedScan(LogToFile logToFile, long l) throws StandardException {
        try {
            this.currentLogFileNumber = LogCounter.getLogFileNumber(l);
            this.logFactory = logToFile;
            this.scan = logToFile.getLogFileAtPosition(l);
            this.setFirstUnflushed();
            this.open = true;
            this.currentInstant = 0L;
        }
        catch (IOException iOException) {
            throw logToFile.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
    }
}

