/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.JarDBFile;
import org.apache.derby.io.StorageFile;

public class JarStorageFactory
extends BaseStorageFactory {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 2004.";
    ZipFile zipData;

    StorageFile newPersistentFile(String string) {
        return new JarDBFile(this, string);
    }

    StorageFile newPersistentFile(String string, String string2) {
        if (string == null || string.length() == 0) {
            return this.newPersistentFile(string2);
        }
        return new JarDBFile(this, string, string2);
    }

    StorageFile newPersistentFile(StorageFile storageFile, String string) {
        if (storageFile == null) {
            return this.newPersistentFile(string);
        }
        return new JarDBFile((JarDBFile)storageFile, string);
    }

    void doInit() throws IOException {
        if (this.dataDirectory == null) {
            return;
        }
        int n = 0;
        while (n < this.dataDirectory.length() & Character.isSpaceChar(this.dataDirectory.charAt(n))) {
            ++n;
        }
        int n2 = -1;
        int n3 = -1;
        if (n < this.dataDirectory.length() && (n2 = this.dataDirectory.indexOf(40, n)) >= 0) {
            n3 = this.dataDirectory.indexOf(41, n2 + 1);
        }
        File file = null;
        if (n3 > 0) {
            file = this.getJarFile(this.dataDirectory.substring(n2 + 1, n3));
            n = n3 + 1;
            while (n < this.dataDirectory.length() & Character.isSpaceChar(this.dataDirectory.charAt(n))) {
                ++n;
            }
            this.dataDirectory = this.dataDirectory.substring(n, this.dataDirectory.length());
        } else {
            file = this.getJarFile(this.dataDirectory);
            this.dataDirectory = "";
        }
        this.zipData = new ZipFile(file);
        this.canonicalName = "(" + file.getCanonicalPath() + ")" + this.dataDirectory;
        this.separatedDataDirectory = this.dataDirectory + "/";
        this.createTempDir();
    }

    private File getJarFile(String string) {
        File file = new File(string);
        if (this.home != null && !file.isAbsolute()) {
            file = new File(this.home, string);
        }
        return file;
    }
}

