/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedStatement
extends ConnectionChild
implements Statement {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private final Connection applicationConnection;
    protected int updateCount = -1;
    protected ResultSet results;
    private ResultSet autoGeneratedKeysResultSet;
    protected String cursorName;
    protected final boolean forMetaData;
    public final int resultSetType;
    protected final int resultSetConcurrency;
    protected final int resultSetHoldability;
    protected final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    protected String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    protected boolean active = true;
    protected Vector batchStatements;
    int maxRows;
    private ParameterValueSet pvs;
    private EmbedResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public ResultSet executeQuery(String string) throws SQLException {
        this.execute(string, true, false, 2, null, null);
        return this.results;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string, false, true, 2, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.execute(string, false, true, n, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Util.notImplemented("executeUpdate(String, int[])");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Util.notImplemented("executeUpdate(String, String[])");
    }

    protected final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null) {
            throw this.newSQLException("XJ068.S");
        }
    }

    public final void close() throws SQLException {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
        }
    }

    protected void closeActions() throws SQLException {
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw this.newSQLException("XJ066.S", new Integer(n));
        }
        this.MaxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw this.newSQLException("XJ063.S", new Integer(n));
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkStatus();
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n != 0) {
            throw Util.notImplemented("setQueryTimeout");
        }
    }

    public void cancel() throws SQLException {
        throw Util.notImplemented("cancel");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.checkStatus();
        this.cursorName = string;
    }

    public boolean execute(String string) throws SQLException {
        return this.execute(string, false, false, 2, null, null);
    }

    protected boolean execute(String string, boolean bl, boolean bl2, int n, int[] nArray, String[] stringArray) throws SQLException {
        if (string == null) {
            throw this.newSQLException("XJ067.S");
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            boolean bl4;
            this.checkExecStatus();
            this.checkIfInMiddleOfBatch();
            this.clearResultSets();
            this.setupContextStack();
            this.SQLText = string;
            try {
                Activation activation;
                try {
                    PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(string);
                    activation = preparedStatement.getActivation(this.lcc, this.resultSetType == 1004);
                    this.checkRequiresCallableStatement(activation);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                activation.setSingleExecution();
                if (n == 1) {
                    activation.setAutoGeneratedKeysResultsetInfo(nArray, stringArray);
                }
                bl4 = this.executeStatement(activation, bl, bl2);
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            {
                bl3 = bl4;
            }
            Object var8_15 = null;
            return bl3;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string, false, false, n, null, null);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Util.notImplemented("execute(String, int[])");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Util.notImplemented("execute(String, String[])");
    }

    public final ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkStatus();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw this.newSQLException("XJ064.S", new Integer(n));
        }
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0 || this.getMaxRows() != 0 && n > this.getMaxRows()) {
            throw this.newSQLException("XJ065.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    public void addBatch(String string) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.addElement(string);
        }
    }

    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sQLException;
            int[] nArray;
            int n;
            block14: {
                int[] nArray2;
                this.setupContextStack();
                n = 0;
                this.clearResultSets();
                Vector vector = this.batchStatements;
                this.batchStatements = null;
                int n2 = vector == null ? 0 : vector.size();
                nArray = new int[n2];
                try {
                    Object var10_8;
                    try {
                        while (true) {
                            if (n >= n2) {
                                nArray2 = nArray;
                                Object var10_7 = null;
                                break;
                            }
                            if (this.executeBatchElement(vector.elementAt(n))) {
                                throw this.newSQLException("XJ04B.S");
                            }
                            nArray[n] = this.getUpdateCount();
                            ++n;
                        }
                    }
                    catch (StandardException standardException) {
                        sQLException = this.handleException(standardException);
                        var10_8 = null;
                        this.restoreContextStack();
                        break block14;
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                        var10_8 = null;
                        this.restoreContextStack();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    this.restoreContextStack();
                    throw throwable;
                }
                this.restoreContextStack();
                return nArray2;
            }
            int[] nArray3 = new int[n];
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray3);
                    batchUpdateException.setNextException(sQLException);
                    throw batchUpdateException;
                }
                nArray3[n3] = nArray[n3];
                ++n3;
            }
        }
    }

    protected boolean executeBatchElement(Object object) throws SQLException, StandardException {
        return this.execute((String)object, false, true, 2, null, null);
    }

    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection != this.applicationConnection || connection == null) {
            throw Util.noCurrentConnection();
        }
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getMoreResults(int n) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n2;
            if (this.dynamicResults == null) {
                this.clearResultSets();
                return false;
            }
            switch (n) {
                default: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    n2 = this.dynamicResults.length;
                    break;
                }
            }
            SQLException sQLException = null;
            int n3 = n2;
            while (n3 <= this.currentDynamicResultSet && n3 < this.dynamicResults.length) {
                EmbedResultSet embedResultSet = this.dynamicResults[n3];
                if (embedResultSet != null) {
                    Object var10_14;
                    try {
                        block19: {
                            try {
                                if (embedResultSet.isClosed) break block19;
                                embedResultSet.close();
                            }
                            catch (SQLException sQLException2) {
                                if (sQLException == null) {
                                    sQLException = sQLException2;
                                } else {
                                    sQLException.setNextException(sQLException2);
                                }
                                var10_14 = null;
                                this.dynamicResults[n3] = null;
                            }
                        }
                        var10_14 = null;
                        this.dynamicResults[n3] = null;
                    }
                    catch (Throwable throwable) {
                        var10_14 = null;
                        this.dynamicResults[n3] = null;
                        throw throwable;
                    }
                }
                ++n3;
            }
            if (sQLException != null) {
                throw sQLException;
            }
            this.updateCount = -1;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                EmbedResultSet embedResultSet = this.dynamicResults[this.currentDynamicResultSet];
                if (embedResultSet == null) continue;
                if (embedResultSet.isClosed) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.results = embedResultSet;
                return true;
            }
            this.results = null;
            return false;
        }
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        this.execute("VALUES IDENTITY_VAL_LOCAL()", true, false, 2, null, null);
        return this.results;
    }

    protected boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            this.setupContextStack();
            this.pvs = activation.getParameterValueSet();
            try {
                block24: {
                    try {
                        if (this.results != null) {
                            this.results.close();
                            this.results = null;
                        }
                        this.clearWarnings();
                        if (!this.forMetaData) {
                            this.commitIfNeeded();
                            this.needCommit();
                        } else if (this.lcc.getActivationCount() <= 1) {
                            this.commitIfNeeded();
                            this.needCommit();
                        }
                        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
                        execPreparedStatement.rePrepare(this.lcc);
                        this.getWarnings(execPreparedStatement.getCompileTimeWarnings());
                        if (this.cursorName != null) {
                            activation.setCursorName(this.cursorName);
                        }
                        activation.setResultSetHoldability(this.resultSetHoldability != 2);
                        activation.reset();
                        activation.setMaxRows(this.maxRows);
                        org.apache.derby.iapi.sql.ResultSet resultSet = execPreparedStatement.execute(activation, bl, bl2, false);
                        this.getWarnings(activation.getWarnings());
                        if (resultSet.returnsRows()) {
                            EmbedResultSet embedResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet, this.forMetaData, this, execPreparedStatement.isAtomic());
                            this.results = embedResultSet;
                            if (activation.isSingleExecution()) {
                                embedResultSet.finalizeActivation = activation;
                            }
                            this.updateCount = -1;
                            bl3 = true;
                            break block24;
                        }
                        if (activation.getAutoGeneratedKeysResultsetMode() && resultSet.getAutoGeneratedKeysResultset() != null) {
                            resultSet.getAutoGeneratedKeysResultset().open();
                            this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet.getAutoGeneratedKeysResultset(), false, this, execPreparedStatement.isAtomic());
                        }
                        this.updateCount = resultSet.modifiedRowCount();
                        resultSet.finish();
                        this.results = null;
                        boolean bl4 = false;
                        if (activation.getDynamicResults() != null) {
                            bl4 = this.processDynamicResults(activation.getDynamicResults(), activation.getMaxDynamicResults());
                        }
                        if (!bl4) {
                            if (activation.isSingleExecution()) {
                                activation.close();
                            }
                            if (!this.forMetaData) {
                                this.commitIfNeeded();
                            } else if (this.lcc.getActivationCount() <= 1) {
                                this.commitIfNeeded();
                            }
                        }
                        bl3 = bl4;
                    }
                    catch (Throwable throwable) {
                        if (activation.isSingleExecution()) {
                            try {
                                activation.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                        throw this.handleException(throwable);
                    }
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            boolean bl5 = bl3;
            Object var5_16 = null;
            return bl5;
        }
    }

    protected void getWarnings(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextException(sQLWarning);
            }
        }
    }

    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    protected final void checkStatus() throws SQLException {
        if (!this.active) {
            throw this.newSQLException("XJ012.S", "Statement");
        }
    }

    protected final void checkExecStatus() throws SQLException {
        if (!this.getConnection().isClosed()) {
            return;
        }
        throw Util.noCurrentConnection();
    }

    protected void clearResultSets() throws SQLException {
        SQLException sQLException = null;
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        try {
            if (this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            }
            sQLException.setNextException(sQLException3);
        }
        if (this.dynamicResults != null) {
            int n = 0;
            while (n < this.dynamicResults.length) {
                EmbedResultSet embedResultSet = this.dynamicResults[n];
                if (embedResultSet != null) {
                    try {
                        if (!embedResultSet.isClosed) {
                            embedResultSet.close();
                        }
                    }
                    catch (SQLException sQLException4) {
                        if (sQLException == null) {
                            sQLException = sQLException4;
                        }
                        sQLException.setNextException(sQLException4);
                    }
                }
                ++n;
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    protected void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet parameterValueSet = activation.getParameterValueSet();
        if (parameterValueSet == null) {
            return;
        }
        if (parameterValueSet.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.newSQLException("XJ009.S", this.SQLText);
        }
    }

    public void transferBatch(EmbedStatement embedStatement) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            embedStatement.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    private boolean processDynamicResults(ResultSet[][] resultSetArray, int n) throws SQLException {
        Object[] objectArray = new EmbedResultSet[resultSetArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < resultSetArray.length) {
            ResultSet[] resultSetArray2 = resultSetArray[n3];
            if (resultSetArray2[0] != null) {
                ResultSet resultSet = resultSetArray2[0];
                resultSetArray2[0] = null;
                if (resultSet instanceof EmbedResultSet) {
                    EmbedResultSet embedResultSet = (EmbedResultSet)resultSet;
                    if (embedResultSet.getEmbedConnection().rootConnection == this.getEmbedConnection().rootConnection && !embedResultSet.isClosed) {
                        embedResultSet.setDynamicResultSet(this);
                        objectArray[n2++] = embedResultSet;
                    }
                }
            }
            ++n3;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                Arrays.sort(objectArray, 0, n2);
            }
            this.dynamicResults = objectArray;
            if (n2 > n) {
                this.getWarnings(StandardException.newWarning("0100E"));
                n3 = n;
                while (n3 < n2) {
                    ((EmbedResultSet)objectArray[n3]).close();
                    objectArray[n3] = null;
                    ++n3;
                }
                n2 = n;
            }
            this.updateCount = -1;
            this.results = objectArray[0];
            this.currentDynamicResultSet = 0;
            return true;
        }
        return false;
    }

    void resultSetClosing(EmbedResultSet embedResultSet) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            int n = 0;
            while (n < this.dynamicResults.length) {
                EmbedResultSet embedResultSet2 = this.dynamicResults[n];
                if (embedResultSet2 != null && !embedResultSet2.isClosed && embedResultSet2 != embedResultSet) {
                    return;
                }
                ++n;
            }
        }
        this.commitIfAutoCommit();
    }

    public EmbedStatement(EmbedConnection embedConnection, boolean bl, int n, int n2, int n3) {
        super(embedConnection);
        this.forMetaData = bl;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.lcc = this.getEmbedConnection().getLanguageConnection();
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
    }
}

