/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockSet;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.TableNameInfo;

class Deadlock {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    static Object[] look(SinglePool singlePool, LockSet lockSet, LockControl lockControl, ActiveLock activeLock, byte by) {
        Hashtable hashtable = Deadlock.getWaiters(lockSet);
        Stack<Object> stack = new Stack<Object>();
        stack.push(activeLock.getCompatabilitySpace());
        stack.push(lockControl.getGrants());
        block0: while (!stack.isEmpty()) {
            List list = (List)stack.peek();
            if (list.isEmpty()) {
                Deadlock.rollback(stack);
                continue;
            }
            int n = list.size() - 1;
            Object object = ((Lock)list.get(n)).getCompatabilitySpace();
            int n2 = 0;
            while (n2 < n) {
                if (object.equals(((Lock)list.get(n2)).getCompatabilitySpace())) {
                    stack.push(object);
                    Deadlock.rollback(stack);
                    continue block0;
                }
                ++n2;
            }
            while (true) {
                Lock lock;
                if ((n2 = stack.indexOf(object)) != -1) {
                    if (n2 == stack.size() - 1 || n2 == stack.size() - 2 && n2 == stack.indexOf(list) - 1) {
                        lock = (ActiveLock)((Dictionary)hashtable).get(object);
                        if (((ActiveLock)lock).canSkip) {
                            stack.push(object);
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                    }
                    return Deadlock.handle(singlePool, stack, n2, hashtable, by);
                }
                stack.push(object);
                lock = (Lock)((Dictionary)hashtable).get(object);
                if (lock == null) {
                    Deadlock.rollback(stack);
                    continue block0;
                }
                Object v = ((Dictionary)hashtable).get(lock);
                if (v instanceof LockControl) {
                    LockControl lockControl2 = (LockControl)v;
                    if (lockControl2.isUnlocked()) {
                        Deadlock.rollback(stack);
                        continue block0;
                    }
                    stack.push(lockControl2.getGrants());
                    continue block0;
                }
                object = lock.getCompatabilitySpace();
            }
        }
        return null;
    }

    private static void rollback(Stack stack) {
        do {
            stack.pop();
            if (!stack.isEmpty()) continue;
            return;
        } while (!(stack.peek() instanceof List));
        List list = (List)stack.peek();
        list.remove(list.size() - 1);
    }

    private static Hashtable getWaiters(LockSet lockSet) {
        Hashtable hashtable = new Hashtable(lockSet.size() * 2);
        Enumeration enumeration = lockSet.elements();
        while (enumeration.hasMoreElements()) {
            Control control = (Control)enumeration.nextElement();
            control.addWaiters(hashtable);
        }
        return hashtable;
    }

    private static Object[] handle(SinglePool singlePool, Stack stack, int n, Dictionary dictionary, byte by) {
        Object e = stack.elementAt(0);
        int n2 = Integer.MAX_VALUE;
        Object var7_7 = null;
        int n3 = n;
        while (n3 < stack.size()) {
            Object e2 = stack.elementAt(n3);
            if (!(e2 instanceof List)) {
                if (e.equals(e2) && by == 2) {
                    var7_7 = e;
                    break;
                }
                LockSpace lockSpace = (LockSpace)singlePool.get(e2);
                if (lockSpace == null) {
                    var7_7 = e2;
                    break;
                }
                int n4 = lockSpace.deadlockCount(n2);
                if (n4 <= n2) {
                    var7_7 = e2;
                    n2 = n4;
                }
            }
            ++n3;
        }
        if (e.equals(var7_7)) {
            Object[] objectArray = new Object[]{stack, dictionary};
            return objectArray;
        }
        ActiveLock activeLock = (ActiveLock)dictionary.get(var7_7);
        activeLock.wakeUp((byte)2);
        return null;
    }

    static StandardException buildException(SinglePool singlePool, Object[] objectArray) {
        Stack stack = (Stack)objectArray[0];
        Dictionary dictionary = (Dictionary)objectArray[1];
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        TableNameInfo tableNameInfo = null;
        TransactionInfo[] transactionInfoArray = null;
        TransactionController transactionController = null;
        if (languageConnectionContext != null) {
            try {
                transactionController = languageConnectionContext.getTransactionExecute();
                tableNameInfo = new TableNameInfo(languageConnectionContext, false);
                transactionInfoArray = languageConnectionContext.getLanguageConnectionFactory().getAccessFactory().getTransactionInfo();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        Hashtable hashtable = new Hashtable(17);
        String string = null;
        int n = 0;
        while (n < stack.size()) {
            Object object;
            Object object2;
            Object e = stack.elementAt(n);
            if (e instanceof List) {
                object2 = (List)e;
                if (object2.size() != 0) {
                    stringBuffer.append("  Granted XID : ");
                    int n2 = 0;
                    while (n2 < object2.size()) {
                        if (n2 != 0) {
                            stringBuffer.append(", ");
                        }
                        object = (Lock)object2.get(n2);
                        stringBuffer.append("{");
                        stringBuffer.append(((Lock)object).getCompatabilitySpace());
                        stringBuffer.append(", ");
                        stringBuffer.append(((Lock)object).getQualifier());
                        stringBuffer.append("} ");
                        ++n2;
                    }
                    stringBuffer.append('\n');
                }
            } else {
                object2 = (Lock)dictionary.get(e);
                ((Lock)object2).getLockable().lockAttributes(-1, hashtable);
                Deadlock.addInfo(stringBuffer, "Lock : ", hashtable.get("TYPE"));
                if (tableNameInfo != null) {
                    Long l = (Long)hashtable.get("CONGLOMID");
                    if (l == null) {
                        object = (Long)hashtable.get("CONTAINERID");
                        try {
                            l = new Long(transactionController.findConglomid((Long)object));
                        }
                        catch (StandardException standardException) {
                            // empty catch block
                        }
                    }
                    Deadlock.addInfo(stringBuffer, ", ", tableNameInfo.getTableName(l));
                }
                Deadlock.addInfo(stringBuffer, ", ", hashtable.get("LOCKNAME"));
                stringBuffer.append('\n');
                String string2 = e.toString();
                if (n == 0) {
                    string = string2;
                }
                Deadlock.addInfo(stringBuffer, "  Waiting XID : {", string2);
                Deadlock.addInfo(stringBuffer, ", ", ((Lock)object2).getQualifier());
                stringBuffer.append("} ");
                if (transactionInfoArray != null) {
                    int n3 = transactionInfoArray.length - 1;
                    while (n3 >= 0) {
                        String string3;
                        TransactionInfo transactionInfo = transactionInfoArray[n3];
                        if (transactionInfo != null && (string3 = transactionInfo.getTransactionIdString()) != null && string3.equals(string2)) {
                            Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getUsernameString());
                            Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getStatementTextString());
                            break;
                        }
                        --n3;
                    }
                }
                stringBuffer.append('\n');
                hashtable.clear();
            }
            ++n;
        }
        StandardException standardException = StandardException.newException("40001", stringBuffer.toString(), string);
        standardException.setReport(singlePool.deadlockMonitor);
        return standardException;
    }

    private static void addInfo(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(string);
        if (object == null) {
            object = "?";
        }
        stringBuffer.append(object);
    }

    private Deadlock() {
    }
}

