/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.util.IdUtil;

class JarFile {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    final String[] name;
    protected ZipFile zip;
    boolean isStream;

    JarFile newJarFile(String[] stringArray) {
        return new JarFile(stringArray);
    }

    final String getJarName() {
        return IdUtil.mkQualifiedName(this.name);
    }

    final boolean isZip() {
        return this.zip != null;
    }

    final ZipFile getZip() {
        return this.zip;
    }

    void initialize(File file) throws IOException {
        this.zip = new ZipFile(file);
    }

    final void setInvalid() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zip = null;
        }
        this.isStream = false;
    }

    ZipEntry getEntry(String string) {
        return this.zip.getEntry(string);
    }

    ZipInputStream getZipOnStream(InputStream inputStream) throws IOException {
        return new ZipInputStream(inputStream);
    }

    ZipEntry getNextEntry(ZipInputStream zipInputStream) throws IOException {
        return zipInputStream.getNextEntry();
    }

    byte[] readData(ZipEntry zipEntry, InputStream inputStream, String string) throws IOException {
        int n;
        int n2 = (int)zipEntry.getSize();
        if (n2 != -1) {
            byte[] byArray = new byte[n2];
            InputStreamUtil.readFully(inputStream, byArray, 0, n2);
            return byArray;
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    Object[] getSigners(String string, ZipEntry zipEntry) throws IOException {
        return null;
    }

    JarFile() {
        this.name = null;
    }

    JarFile(String[] stringArray) {
        this.name = stringArray;
    }
}

