/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.uuid;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;

public class BasicUUID
implements UUID,
Formatable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private long majorId;
    private long timemillis;
    private int sequence;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.majorId);
        objectOutput.writeLong(this.timemillis);
        objectOutput.writeInt(this.sequence);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.majorId = objectInput.readLong();
        this.timemillis = objectInput.readLong();
        this.sequence = objectInput.readInt();
    }

    public int getTypeFormatId() {
        return 131;
    }

    private static void writeMSB(char[] cArray, int n, long l, int n2) {
        int n3 = n2 - 1;
        while (n3 >= 0) {
            long l2 = (l & 255L << 8 * n3) >>> 8 * n3;
            int n4 = (int)((l2 & 0xF0L) >> 4);
            cArray[n++] = (char)(n4 < 10 ? n4 + 48 : n4 - 10 + 97);
            n4 = (int)(l2 & 0xFL);
            cArray[n++] = (char)(n4 < 10 ? n4 + 48 : n4 - 10 + 97);
            --n3;
        }
    }

    private static long readMSB(StringReader stringReader) {
        long l = 0L;
        try {
            int n;
            while ((n = stringReader.read()) != -1) {
                if (n != 45) {
                    l <<= 4;
                    int n2 = n <= 57 ? n - 48 : (n <= 70 ? n - 65 + 10 : n - 97 + 10);
                    l += (long)n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicUUID)) {
            return false;
        }
        BasicUUID basicUUID = (BasicUUID)object;
        return this.sequence == basicUUID.sequence && this.timemillis == basicUUID.timemillis && this.majorId == basicUUID.majorId;
    }

    public int hashCode() {
        long l = this.majorId ^ this.timemillis;
        return this.sequence ^ (int)(l >> 4);
    }

    public String toString() {
        return this.stringWorkhorse('-');
    }

    public String toANSIidentifier() {
        return "U" + this.stringWorkhorse('X');
    }

    public String stringWorkhorse(char c) {
        char[] cArray = new char[36];
        BasicUUID.writeMSB(cArray, 0, this.sequence, 4);
        int n = 8;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        long l = this.timemillis;
        BasicUUID.writeMSB(cArray, n, (l & 0xFFFF00000000L) >>> 32, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, (l & 0xFFFF0000L) >>> 16, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, l & 0xFFFFL, 2);
        n += 4;
        if (c != '\u0000') {
            cArray[n++] = c;
        }
        BasicUUID.writeMSB(cArray, n, this.majorId, 6);
        return new String(cArray, 0, n += 12);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[16];
        int n = this.sequence;
        byArray[0] = (byte)((n & 0xFF000000) >>> 24);
        byArray[1] = (byte)((n & 0xFF0000) >>> 16);
        byArray[2] = (byte)((n & 0xFF00) >>> 8);
        byArray[3] = (byte)(n & 0xFF);
        long l = this.timemillis;
        byArray[4] = (byte)((l & 0xFF0000000000L) >>> 40);
        byArray[5] = (byte)((l & 0xFF00000000L) >>> 32);
        byArray[6] = (byte)((l & 0xFF000000L) >>> 24);
        byArray[7] = (byte)((l & 0xFF0000L) >>> 16);
        byArray[8] = (byte)((l & 0xFF00L) >>> 8);
        byArray[9] = (byte)(l & 0xFFL);
        long l2 = this.majorId;
        byArray[10] = (byte)((l2 & 0xFF0000000000L) >>> 40);
        byArray[11] = (byte)((l2 & 0xFF00000000L) >>> 32);
        byArray[12] = (byte)((l2 & 0xFF000000L) >>> 24);
        byArray[13] = (byte)((l2 & 0xFF0000L) >>> 16);
        byArray[14] = (byte)((l2 & 0xFF00L) >>> 8);
        byArray[15] = (byte)(l2 & 0xFFL);
        return byArray;
    }

    public UUID cloneMe() {
        return new BasicUUID(this.majorId, this.timemillis, this.sequence);
    }

    public String toHexString() {
        return this.stringWorkhorse('\u0000');
    }

    public BasicUUID(long l, long l2, int n) {
        this.majorId = l;
        this.timemillis = l2;
        this.sequence = n;
    }

    public BasicUUID(String string) {
        StringReader stringReader = new StringReader(string);
        this.sequence = (int)BasicUUID.readMSB(stringReader);
        long l = BasicUUID.readMSB(stringReader) << 32;
        l += BasicUUID.readMSB(stringReader) << 16;
        this.timemillis = l += BasicUUID.readMSB(stringReader);
        this.majorId = BasicUUID.readMSB(stringReader);
    }

    public BasicUUID(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            n <<= 8;
            n |= 0xFF & byArray[n2];
            ++n2;
        }
        long l = 0L;
        int n3 = 4;
        while (n3 < 10) {
            l <<= 8;
            l |= (long)(0xFF & byArray[n3]);
            ++n3;
        }
        long l2 = 0L;
        int n4 = 10;
        while (n4 < 16) {
            l2 <<= 8;
            l2 |= (long)(0xFF & byArray[n4]);
            ++n4;
        }
        this.sequence = n;
        this.timemillis = l;
        this.majorId = l2;
    }

    public BasicUUID() {
    }
}

