/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BooleanTypeCompiler
extends BaseTypeCompiler {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";

    public boolean comparable(TypeId typeId, boolean bl, ClassFactory classFactory) {
        TypeId typeId2 = this.getTypeId();
        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
        return typeId.getSQLTypeName().equals(typeId2.getSQLTypeName()) || typeId.isStringTypeId() || typeId.isNumericTypeId() || typeId.userType() && typeCompiler.comparable(typeId2, bl, classFactory);
    }

    public boolean convertible(TypeId typeId, boolean bl) {
        int n = typeId.getJDBCTypeId();
        return n != 91 && n != 92 && n != 93;
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (typeId.isBooleanTypeId() || typeId.isStringTypeId() || typeId.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BooleanDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 5;
    }

    protected String nullMethodName() {
        return "getNullBoolean";
    }
}

