/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ConcatenationOperatorNode
extends BinaryOperatorNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";

    public void init(Object object, Object object2) {
        super.init(object, object2, "||", "concatenate", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.ConcatableDataValue");
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object;
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, vector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, vector);
        if (this.leftOperand.isParameterNode()) {
            if (this.rightOperand.isParameterNode()) {
                throw StandardException.newException("42X35", this.operator);
            }
            object = this.rightOperand.getTypeId().isBitTypeId() ? TypeId.getBuiltInTypeId(-3) : TypeId.getBuiltInTypeId(12);
            ((ParameterNode)this.leftOperand).setDescriptor(new DataTypeDescriptor((TypeId)object, true));
        }
        if (this.rightOperand.isParameterNode()) {
            object = this.leftOperand.getTypeId().isBitTypeId() ? TypeId.getBuiltInTypeId(-3) : TypeId.getBuiltInTypeId(12);
            ((ParameterNode)this.rightOperand).setDescriptor(new DataTypeDescriptor((TypeId)object, true));
        }
        if (!this.leftOperand.getTypeId().systemBuiltIn()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (!this.rightOperand.getTypeId().systemBuiltIn()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        object = this.leftOperand.getTypeCompiler();
        if (!this.leftOperand.getTypeId().isStringTypeId() && !this.leftOperand.getTypeId().isBitTypeId()) {
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, object.getCastToCharWidth(this.leftOperand.getTypeServices())), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        }
        object = this.rightOperand.getTypeCompiler();
        if (!this.rightOperand.getTypeId().isStringTypeId() && !this.rightOperand.getTypeId().isBitTypeId()) {
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, object.getCastToCharWidth(this.rightOperand.getTypeServices())), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        object = this.leftOperand.getTypeCompiler();
        this.setType(this.resolveConcatOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
        this.setLeftRightInterfaceType(object.interfaceName());
        return this;
    }

    private DataTypeDescriptor resolveConcatOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        int n;
        String string;
        block27: {
            TypeId typeId;
            TypeId typeId2;
            block29: {
                block28: {
                    block26: {
                        typeId2 = dataTypeDescriptor.getTypeId();
                        typeId = dataTypeDescriptor2.getTypeId();
                        if (!typeId2.isConcatableTypeId() || !typeId.isConcatableTypeId() || typeId.isBitTypeId() && typeId2.isStringTypeId() || typeId2.isBitTypeId() && typeId.isStringTypeId()) {
                            throw StandardException.newException("42884", "||", (Object)"FUNCTION");
                        }
                        string = typeId2.typePrecedence() >= typeId.typePrecedence() ? dataTypeDescriptor.getTypeName() : dataTypeDescriptor2.getTypeName();
                        n = dataTypeDescriptor.getMaximumWidth() + dataTypeDescriptor2.getMaximumWidth();
                        if (typeId2.getJDBCTypeId() != 1 && typeId2.getJDBCTypeId() != -2) break block26;
                        switch (typeId.getJDBCTypeId()) {
                            case -2: 
                            case 1: {
                                if (n > 254) {
                                    if (typeId.getJDBCTypeId() == 1) {
                                        string = "VARCHAR";
                                        break;
                                    }
                                    string = "VARCHAR () FOR BIT DATA";
                                    break;
                                }
                                break block27;
                            }
                            case -3: 
                            case 12: {
                                if (n > 4000) {
                                    if (typeId.getJDBCTypeId() == 12) {
                                        string = "LONG VARCHAR";
                                        break;
                                    }
                                    string = "LONG VARCHAR FOR BIT DATA";
                                    break;
                                }
                                break block27;
                            }
                            case 2004: 
                            case 2005: {
                                n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                                break;
                            }
                        }
                        break block27;
                    }
                    if (typeId2.getJDBCTypeId() != 12) break block28;
                    switch (typeId.getJDBCTypeId()) {
                        case 1: 
                        case 12: {
                            if (n > 4000) {
                                string = "LONG VARCHAR";
                                break;
                            }
                            break block27;
                        }
                        case 2005: {
                            n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                            break;
                        }
                    }
                    break block27;
                }
                if (typeId2.getJDBCTypeId() != -3) break block29;
                switch (typeId.getJDBCTypeId()) {
                    case -3: 
                    case -2: {
                        if (n > 4000) {
                            string = "LONG VARCHAR FOR BIT DATA";
                            break;
                        }
                        break block27;
                    }
                    case 2004: {
                        n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                        break;
                    }
                }
                break block27;
            }
            if (typeId2.getJDBCTypeId() == 2005 || typeId2.getJDBCTypeId() == 2004) {
                n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor, dataTypeDescriptor2);
            } else if (typeId.getJDBCTypeId() == 2005 || typeId.getJDBCTypeId() == 2004) {
                n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
            }
        }
        if (string.equals("LONG VARCHAR")) {
            n = 32700;
        } else if (string.equals("LONG VARCHAR FOR BIT DATA")) {
            n = 32700;
        }
        boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(string), bl, n);
    }

    protected void initializeResultField(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, LocalField localField) {
        methodBuilder.conditionalIfNull();
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler());
        methodBuilder.startElseCode();
        methodBuilder.getField(localField);
        methodBuilder.completeConditional();
    }

    private static int clobBlobHandling(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        int n = dataTypeDescriptor2.getTypeId().getJDBCTypeId() == -1 || dataTypeDescriptor2.getTypeId().getJDBCTypeId() == -4 ? dataTypeDescriptor.getMaximumWidth() + 32768 : dataTypeDescriptor.getMaximumWidth() + dataTypeDescriptor2.getMaximumWidth();
        if (n < 1) {
            return Integer.MAX_VALUE;
        }
        return n;
    }
}

