/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumnList
extends QueryTreeNodeVector {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected boolean indexRow;
    protected long conglomerateId;
    int orderBySelect = 0;
    protected boolean forUpdate;
    private boolean countMismatchAllowed;

    public void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.addElement(resultColumn);
    }

    public void appendResultColumns(ResultColumnList resultColumnList, boolean bl) {
        int n = this.size();
        int n2 = n + 1;
        int n3 = resultColumnList.size();
        int n4 = 0;
        while (n4 < n3) {
            ((ResultColumn)resultColumnList.elementAt(n4)).setVirtualColumnId(n2);
            ++n2;
            ++n4;
        }
        if (bl) {
            this.destructiveAppend(resultColumnList);
        } else {
            this.nondestructiveAppend(resultColumnList);
        }
    }

    public ResultColumn getResultColumn(int n) {
        ResultColumn resultColumn;
        if (n <= this.size() && (resultColumn = (ResultColumn)this.elementAt(n - 1)).getColumnPosition() == n) {
            return resultColumn;
        }
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n3);
            if (resultColumn2.getColumnPosition() == n) {
                return resultColumn2;
            }
            ++n3;
        }
        return null;
    }

    public ResultColumn getOrderByColumn(int n) {
        if (n == 0) {
            return null;
        }
        return this.getResultColumn(n);
    }

    public ResultColumn getResultColumn(String string) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (string.equals(resultColumn.getName())) {
                resultColumn.setReferenced();
                return resultColumn;
            }
            ++n2;
        }
        return null;
    }

    public ResultColumn getResultColumn(String string, String string2) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if ((string == null || resultColumn.getTableName() != null && string.equals(resultColumn.getTableName())) && string2.equals(resultColumn.getName())) {
                resultColumn.setReferenced();
                return resultColumn;
            }
            ++n2;
        }
        return null;
    }

    public ResultColumn getAtMostOneResultColumn(ColumnReference columnReference, String string) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        String string2 = columnReference.getColumnName();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n2);
            if (string2.equals(resultColumn2.getName())) {
                if (resultColumn != null) {
                    throw StandardException.newException("42Y34", string2, (Object)string);
                }
                resultColumn2.setReferenced();
                resultColumn = resultColumn2;
            }
            ++n2;
        }
        return resultColumn;
    }

    public ResultColumn getOrderByColumn(String string, String string2, int n) throws StandardException {
        int n2 = this.size();
        ResultColumn resultColumn = null;
        int n3 = 0;
        while (n3 < n2) {
            ValueNode valueNode;
            String string3;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n3);
            if (string2 == null || !((string3 = resultColumn2.getTableName()) != null ? !string2.equals(resultColumn2.getTableName()) : !((valueNode = resultColumn2.getExpression()) instanceof ColumnReference) || n != ((ColumnReference)valueNode).getTableNumber())) {
                if (string.equals(resultColumn2.getName())) {
                    if (resultColumn == null) {
                        resultColumn = resultColumn2;
                    } else {
                        if (n3 < n2 - this.orderBySelect) {
                            throw StandardException.newException("42X79", string);
                        }
                        this.removeElement(resultColumn2);
                        this.decOrderBySelect();
                        break;
                    }
                }
            }
            ++n3;
        }
        return resultColumn;
    }

    public ResultColumn getOrderByColumn(String string, String string2) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n2);
            if ((string2 == null || (valueNode = resultColumn2.getExpression()) != null && resultColumn2.getTableName() != null && valueNode instanceof ColumnReference && string2.equals(resultColumn2.getTableName())) && string.equals(resultColumn2.getName())) {
                if (resultColumn == null) {
                    resultColumn = resultColumn2;
                } else {
                    if (n2 < n - this.orderBySelect) {
                        throw StandardException.newException("42X79", string);
                    }
                    this.removeElement(resultColumn2);
                    this.decOrderBySelect();
                    break;
                }
            }
            ++n2;
        }
        return resultColumn;
    }

    void copyResultColumnNames(ResultColumnList resultColumnList) {
        int n = this.countMismatchAllowed ? resultColumnList.size() : this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(n2);
            resultColumn.setName(resultColumn2.getName());
            resultColumn.setNameGenerated(resultColumn2.isNameGenerated());
            ++n2;
        }
    }

    public void treePrint(int n) {
    }

    public void bindExpressions(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.expandAllsAndNameColumns(fromList);
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode = (ValueNode)this.elementAt(n2);
            valueNode = ((ResultColumn)valueNode).bindExpression(fromList, subqueryList, vector);
            this.setElementAt(valueNode, n2);
            ++n2;
        }
    }

    public void bindResultColumnsToExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).bindResultColumnToExpression();
            ++n2;
        }
    }

    public void bindResultColumnsByName(TableDescriptor tableDescriptor, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            String string = resultColumn.getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            resultColumn.bindResultColumnByName(tableDescriptor, n2 + 1);
            ++n2;
        }
    }

    public void bindResultColumnsByName(ResultColumnList resultColumnList, FromVTI fromVTI, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            String string = resultColumn.getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            ResultColumn resultColumn2 = resultColumnList.getResultColumn(null, resultColumn.getName());
            if (resultColumn2 == null) {
                throw StandardException.newException("42X14", resultColumn.getName(), (Object)fromVTI.getNewInvocation().getJavaClassName());
            }
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(resultColumn.getName(), resultColumn2.getVirtualColumnId(), resultColumn2.getType(), null, null, null, null, 0L, 0L, false);
            resultColumn.setColumnDescriptor(null, columnDescriptor);
            resultColumn.setVirtualColumnId(n2 + 1);
            ++n2;
        }
    }

    public void bindResultColumnsByPosition(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).bindResultColumnByPosition(tableDescriptor, n2 + 1);
            ++n2;
        }
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            this.setElementAt(resultColumn.preprocess(n, fromList, subqueryList, predicateList), n3);
            ++n3;
        }
    }

    void checkStorableExpressions(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            ((ResultColumn)this.elementAt(n2)).checkStorableExpression(resultColumn);
            ++n2;
        }
    }

    public int[] getStreamStorableColIds(int n) throws StandardException {
        int n2 = 0;
        boolean[] blArray = new boolean[n];
        int n3 = this.size();
        int n4 = 0;
        while (n4 < n3) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n4);
            if (resultColumn.getTypeId().streamStorable()) {
                ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
                blArray[columnDescriptor.getPosition() - 1] = true;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < blArray.length) {
            if (blArray[n4]) {
                ++n2;
            }
            ++n4;
        }
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < blArray.length) {
            if (blArray[n6]) {
                nArray[n5++] = n6;
            }
            ++n6;
        }
        return nArray;
    }

    void checkStorableExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).checkStorableExpression();
            ++n2;
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, false);
    }

    void generateNulls(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, true);
    }

    void generateCore(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, "getValueRow", "org.apache.derby.iapi.sql.execute.ExecRow", this.size());
        int n = this.size();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getConstructor();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (bl || (!((valueNode = resultColumn.getExpression()) instanceof VirtualColumnNode) || ((VirtualColumnNode)valueNode).getCorrelated()) && (!(valueNode instanceof ColumnReference) || ((ColumnReference)valueNode).getCorrelated())) {
                if (!bl && resultColumn.getExpression() instanceof ConstantNode && !((ConstantNode)resultColumn.getExpression()).isNull() && !methodBuilder3.statementNumHitLimit(1)) {
                    methodBuilder3.getField(localField);
                    methodBuilder3.push(n2 + 1);
                    resultColumn.generateExpression(expressionClassBuilder, methodBuilder3);
                    methodBuilder3.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                    methodBuilder3.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                } else {
                    methodBuilder2.getField(localField);
                    methodBuilder2.push(n2 + 1);
                    boolean bl2 = true;
                    if (resultColumn.isAutoincrementGenerated()) {
                        methodBuilder2.pushThis();
                        methodBuilder2.push(resultColumn.getColumnPosition());
                        methodBuilder2.push(resultColumn.getTableColumnDescriptor().getAutoincInc());
                        methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getSetAutoincrementValue", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
                        bl2 = false;
                    } else if (bl || resultColumn.getExpression() instanceof ConstantNode && ((ConstantNode)resultColumn.getExpression()).isNull()) {
                        methodBuilder2.getField(localField);
                        methodBuilder2.push(n2 + 1);
                        methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                        expressionClassBuilder.generateNullWithExpress(methodBuilder2, resultColumn.getTypeCompiler());
                    } else {
                        resultColumn.generateExpression(expressionClassBuilder, methodBuilder2);
                    }
                    if (bl2) {
                        methodBuilder2.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                    }
                    methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                }
            }
            ++n2;
        }
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    public ExecRow buildEmptyRow() throws StandardException {
        int n = this.size();
        ExecRow execRow = this.getExecutionFactory().getValueRow(n);
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(n2++, dataValueDescriptor);
            ++n3;
        }
        return execRow;
    }

    public ExecRow buildEmptyIndexRow(TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, StoreCostController storeCostController, DataDictionary dataDictionary) throws StandardException {
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        ExecRow execRow = this.getExecutionFactory().getValueRow(nArray.length + 1);
        int n = 0;
        while (n < nArray.length) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[n]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(n + 1, dataValueDescriptor);
            ++n;
        }
        RowLocation rowLocation = storeCostController.newRowLocationTemplate();
        execRow.setColumn(nArray.length + 1, rowLocation);
        return execRow;
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateHolder(expressionClassBuilder, methodBuilder, null, null);
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        expressionClassBuilder.pushMethodReference(methodBuilder, this.generateHolderMethod(expressionClassBuilder, formatableBitSet, formatableBitSet2));
    }

    MethodBuilder generateHolderMethod(ExpressionClassBuilder expressionClassBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        String string;
        String string2;
        int n = -1;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.anySetBit();
            while (n2 != -1) {
                n = n2;
                n2 = formatableBitSet.anySetBit(n2);
            }
        } else {
            n = this.size() - 1;
        }
        MethodBuilder methodBuilder = expressionClassBuilder.newExprFun();
        if (this.indexRow) {
            string2 = "getIndexableRow";
            string = "org.apache.derby.iapi.sql.execute.ExecIndexRow";
        } else {
            string2 = "getValueRow";
            string = "org.apache.derby.iapi.sql.execute.ExecRow";
        }
        int n3 = this.size();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, string2, string, n + 1);
        int n4 = formatableBitSet != null ? formatableBitSet.anySetBit() : 0;
        int n5 = 0;
        while (n5 < n3) {
            Object object;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n5);
            if (resultColumn.getExpression() instanceof CurrentRowLocationNode) {
                RowLocation rowLocation;
                object = null;
                object = this.getLanguageConnectionContext().getTransactionCompile().openConglomerate(this.conglomerateId, false, 0, 6, 2);
                try {
                    rowLocation = object.newRowLocationTemplate();
                }
                finally {
                    Object var17_17 = null;
                    if (object != null) {
                        object.close();
                    }
                }
                int n6 = expressionClassBuilder.addItem(rowLocation);
                methodBuilder.getField(localField);
                methodBuilder.push(n + 1);
                methodBuilder.pushThis();
                methodBuilder.push(n6);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getRowLocationTemplate", "org.apache.derby.iapi.types.RowLocation", 1);
                methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
            } else if (formatableBitSet2 == null || formatableBitSet2.getNumBitsSet() == 0 || !((object = resultColumn.getExpression()) instanceof VirtualColumnNode)) {
                methodBuilder.getField(localField);
                methodBuilder.push(n4 + 1);
                resultColumn.generateHolder(expressionClassBuilder, methodBuilder);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                n4 = formatableBitSet != null ? formatableBitSet.anySetBit(n4) : ++n4;
            }
            ++n5;
        }
        methodBuilder.getField(localField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    private void genCreateRow(ExpressionClassBuilder expressionClassBuilder, LocalField localField, String string, String string2, int n) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, string, string2, 1);
        methodBuilder.putField(localField);
        methodBuilder.endStatement();
        methodBuilder.statementNumHitLimit(1);
    }

    public ResultColumnDescriptor[] makeResultDescriptors() {
        ExecutionContext executionContext = (ExecutionContext)this.getContextManager().getContext("ExecutionContext");
        return this.makeResultDescriptors(executionContext);
    }

    ResultColumnDescriptor[] makeResultDescriptors(ExecutionContext executionContext) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[this.size()];
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            resultColumnDescriptorArray[n2] = executionContext.getExecutionFactory().getResultColumnDescriptor((ResultColumnDescriptor)((Object)this.elementAt(n2)));
            ++n2;
        }
        return resultColumnDescriptorArray;
    }

    public void expandAllsAndNameColumns(FromList fromList) throws StandardException {
        boolean bl = false;
        int n = 0;
        while (n < this.size()) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (resultColumn instanceof AllResultColumn) {
                bl = true;
                String string = ((AllResultColumn)resultColumn).getFullTableName();
                ResultColumnList resultColumnList = fromList.expandAll(string);
                resultColumnList.nameAllResultColumns();
                resultColumnList.setClause(1);
                this.removeElementAt(n);
                int n2 = 0;
                while (n2 < resultColumnList.size()) {
                    this.insertElementAt(resultColumnList.elementAt(n2), n + n2);
                    ++n2;
                }
            } else {
                resultColumn.guaranteeColumnName();
            }
            ++n;
        }
        if (bl) {
            n = this.size();
            int n3 = 0;
            while (n3 < n) {
                ((ResultColumn)this.elementAt(n3)).setVirtualColumnId(n3 + 1);
                ++n3;
            }
        }
    }

    public void nameAllResultColumns() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.guaranteeColumnName();
            ++n2;
        }
    }

    public void copyTypesAndLengthsToSource(ResultColumnList resultColumnList) {
        int n = this.size() > resultColumnList.size() ? this.size() : resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n2);
            resultColumn.setType(resultColumn2.getTypeServices());
            resultColumn.getExpression().setType(resultColumn2.getTypeServices());
            ++n2;
        }
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!resultColumn.isGenerated() && !resultColumn.columnTypeAndLengthMatch()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean columnTypesAndLengthsMatch(ResultColumnList resultColumnList) throws StandardException {
        boolean bl = true;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(n2);
            if (!(resultColumn.isGenerated() || resultColumn2.isGenerated() || resultColumn.columnTypeAndLengthMatch(resultColumn2))) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public boolean nopProjection(ResultColumnList resultColumnList) {
        if (this.size() != resultColumnList.size()) {
            return false;
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = null;
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                resultColumn2 = ((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn();
            } else if (resultColumn.getExpression() instanceof ColumnReference) {
                resultColumn2 = ((ColumnReference)resultColumn.getExpression()).getSource();
            } else {
                return false;
            }
            ResultColumn resultColumn3 = (ResultColumn)resultColumnList.elementAt(n2);
            if (resultColumn2 != resultColumn3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public ResultColumnList copyListAndObjects() throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = resultColumn.cloneMe();
            resultColumnList.addResultColumn(resultColumn2);
            ++n2;
        }
        return resultColumnList;
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList) throws StandardException {
        this.genVirtualColumnNodes(resultSetNode, resultColumnList, true);
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            resultColumn.expression = (ValueNode)this.getNodeFactory().getNode(107, resultSetNode, resultColumnList.elementAt(n2), ReuseFactory.getInteger(n2 + 1), this.getContextManager());
            if (bl) {
                resultColumn.setReferenced();
            }
            ++n2;
        }
    }

    public void adjustVirtualColumnIds(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            resultColumn.adjustVirtualColumnId(n);
            ((VirtualColumnNode)resultColumn.getExpression()).columnId += n;
            ++n3;
        }
    }

    public void doProjection() throws StandardException {
        int n = 0;
        int n2 = this.size();
        ResultColumnList resultColumnList = new ResultColumnList();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            if (!resultColumn.isReferenced() && resultColumn.getExpression() instanceof VirtualColumnNode && !((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn().isReferenced()) {
                resultColumnList.addElement(resultColumn);
                ++n;
            } else {
                if (n >= 1) {
                    resultColumn.adjustVirtualColumnId(-n);
                }
                resultColumn.setReferenced();
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < resultColumnList.size()) {
            this.removeElement((ResultColumn)resultColumnList.elementAt(n3));
            ++n3;
        }
    }

    public String verifyUniqueNames(boolean bl) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (bl && resultColumn.isNameGenerated()) {
                throw StandardException.newException("42908");
            }
            String string = ((ResultColumn)this.elementAt(n2)).getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public void propagateDCLInfo(ResultColumnList resultColumnList, String string) throws StandardException {
        if (resultColumnList.size() != this.size() && !resultColumnList.getCountMismatchAllowed()) {
            throw StandardException.newException("42X32", string);
        }
        String string2 = resultColumnList.verifyUniqueNames(false);
        if (string2 != null) {
            throw StandardException.newException("42X33", string2);
        }
        this.copyResultColumnNames(resultColumnList);
    }

    void rejectParameters() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.rejectParameter();
            ++n2;
        }
    }

    public void setResultSetNumber(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ((ResultColumn)this.elementAt(n3)).setResultSetNumber(n);
            ++n3;
        }
    }

    public void setRedundant() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).setRedundant();
            ++n2;
        }
    }

    public void checkColumnUpdateability(String[] stringArray, String string) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.updated() && !resultColumn.foundInList(stringArray)) {
                throw StandardException.newException("42X31", resultColumn.getName(), (Object)string);
            }
            ++n2;
        }
    }

    public void setUnionResultExpression(ResultColumnList resultColumnList, int n, int n2) throws StandardException {
        TableName tableName = (TableName)this.getNodeFactory().getNode(34, null, null, this.getContextManager());
        ContextManager contextManager = this.getContextManager();
        int n3 = this.size();
        int n4 = 0;
        while (n4 < n3) {
            TypeId typeId;
            TypeId typeId2;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n4);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(n4);
            ValueNode valueNode = resultColumn.getExpression();
            ValueNode valueNode2 = resultColumn2.getExpression();
            if (!resultColumn2.isAutoincrementGenerated() && resultColumn.isAutoincrementGenerated()) {
                resultColumn.resetAutoincrementGenerated();
            }
            if ((typeId2 = valueNode.getTypeId()) != null && (typeId = valueNode2.getTypeId()) != null) {
                ClassFactory classFactory = this.getClassFactory();
                if (!valueNode.getTypeCompiler().storable(typeId, classFactory) && !valueNode2.getTypeCompiler().storable(typeId2, classFactory)) {
                    throw StandardException.newException("42X61", typeId2.getSQLTypeName(), (Object)typeId.getSQLTypeName());
                }
                DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices().getDominantType(valueNode2.getTypeServices(), classFactory);
                ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), tableName, this.getContextManager());
                columnReference.setType(dataTypeDescriptor);
                if (valueNode instanceof ColumnReference) {
                    columnReference.copyFields((ColumnReference)valueNode);
                } else {
                    columnReference.setNestingLevel(n2);
                    columnReference.setSourceLevel(n2);
                }
                columnReference.setTableNumber(n);
                resultColumn.setExpression(columnReference);
                resultColumn.setType(resultColumn.getTypeServices().getDominantType(resultColumn2.getTypeServices(), classFactory));
                if (resultColumn.getName() != null && !resultColumn.isNameGenerated() && resultColumn2.getName() != null) {
                    if (resultColumn2.isNameGenerated()) {
                        resultColumn.setName(resultColumn2.getName());
                        resultColumn.setNameGenerated(true);
                    } else if (!resultColumn.getName().equals(resultColumn2.getName())) {
                        resultColumn.setName(null);
                        resultColumn.guaranteeColumnName();
                        resultColumn.setNameGenerated(true);
                    }
                }
            }
            ++n4;
        }
    }

    public void checkAutoincrementUnion(ResultSetNode resultSetNode) throws StandardException {
        ResultSetNode resultSetNode2 = ((TableOperatorNode)resultSetNode).getLeftResultSet();
        ResultSetNode resultSetNode3 = ((TableOperatorNode)resultSetNode).getRightResultSet();
        if (resultSetNode2 instanceof UnionNode) {
            this.checkAutoincrementUnion(resultSetNode2);
        } else {
            this.checkAutoincrement(resultSetNode2.getResultColumns());
        }
        if (resultSetNode3 instanceof UnionNode) {
            this.checkAutoincrementUnion(resultSetNode3);
        } else {
            this.checkAutoincrement(resultSetNode3.getResultColumns());
        }
    }

    public boolean isExactTypeAndLengthMatch(ResultColumnList resultColumnList) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(n2);
            if (!resultColumn.getTypeServices().isExactTypeAndLengthMatch(resultColumn2.getTypeServices())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean updateOverlaps(int[] nArray) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.updated()) {
                int n3 = resultColumn.getColumnPosition();
                int n4 = 0;
                while (n4 < nArray.length) {
                    if (nArray[n4] == n3) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    ResultColumn[] getSortedByPosition() {
        int n = this.size();
        Object[] objectArray = new ResultColumn[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = (ResultColumn)this.elementAt(n2);
            ++n2;
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public int[] sortMe() {
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int[] nArray = new int[resultColumnArray.length];
        int n = 0;
        while (n < resultColumnArray.length) {
            nArray[n] = resultColumnArray[n].getColumnPosition();
            ++n;
        }
        return nArray;
    }

    public ResultColumnList expandToAll(TableDescriptor tableDescriptor, TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int n = 0;
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn;
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(n3);
            if (n < resultColumnArray.length && columnDescriptor.getPosition() == resultColumnArray[n].getColumnPosition()) {
                resultColumn = resultColumnArray[n];
                ++n;
            } else {
                resultColumn = this.makeColumnReferenceFromName(tableName, columnDescriptor.getColumnName());
                resultColumn.bindResultColumnByPosition(tableDescriptor, columnDescriptor.getPosition());
            }
            resultColumnList.addResultColumn(resultColumn);
            ++n3;
        }
        return resultColumnList;
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            throw StandardException.newException("42X07");
        }
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(n2);
            resultColumn2.typeUntypedNullExpression(resultColumn);
            ++n2;
        }
    }

    void markUpdated() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).markUpdated();
            ++n2;
        }
    }

    void markUpdatableByCursor() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).markUpdatableByCursor();
            ++n2;
        }
    }

    public String verifyCreateConstraintColumnList(TableElementList tableElementList) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            String string = ((ResultColumn)this.elementAt(n2)).getName();
            if (!tableElementList.containsColumnName(string)) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public void exportNames(String[] stringArray) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((ResultColumn)this.elementAt(n2)).getName();
            ++n2;
        }
    }

    public int countNumberOfSimpleColumnReferences() {
        int n = 0;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((ResultColumn)this.elementAt(n3)).getExpression() instanceof ColumnReference) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public ResultColumn findParentResultColumn(ResultColumn resultColumn) {
        ResultColumn resultColumn2 = null;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode;
            ResultColumn resultColumn3 = (ResultColumn)this.elementAt(n2);
            if (resultColumn3.getExpression() instanceof ColumnReference) {
                valueNode = (ColumnReference)resultColumn3.getExpression();
                if (((ColumnReference)valueNode).getSource() == resultColumn) {
                    resultColumn2 = resultColumn3;
                    break;
                }
            } else if (resultColumn3.getExpression() instanceof VirtualColumnNode && ((VirtualColumnNode)(valueNode = (VirtualColumnNode)resultColumn3.getExpression())).getSourceColumn() == resultColumn) {
                resultColumn2 = resultColumn3;
                break;
            }
            ++n2;
        }
        return resultColumn2;
    }

    public void setClause(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            resultColumn.setClause(n);
            ++n3;
        }
    }

    void markUpdated(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            ResultColumn resultColumn2 = this.getResultColumn(resultColumn.getName());
            if (resultColumn2 != null) {
                resultColumn2.markUpdated();
            }
            ++n2;
        }
    }

    void markUpdatableByCursor(Vector vector) {
        if (vector == null || vector.size() == 0) {
            this.markUpdatableByCursor();
        } else {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                ResultColumn resultColumn = this.getResultColumn(string);
                resultColumn.markUpdatableByCursor();
                ++n2;
            }
        }
    }

    boolean updatableByCursor(int n) {
        return this.getResultColumn(n).updatableByCursor();
    }

    public boolean isCloneable() {
        boolean bl = true;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!resultColumn.getExpression().isCloneable()) {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.setExpression(resultColumn.getExpression().remapColumnReferencesToExpressions());
            ++n2;
        }
    }

    void setIndexRow(long l, boolean bl) {
        this.indexRow = true;
        this.conglomerateId = l;
        this.forUpdate = bl;
    }

    public boolean hasConsistentTypeInfo() {
        boolean bl = true;
        return bl;
    }

    public boolean containsAllResultColumn() {
        boolean bl = false;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.elementAt(n2) instanceof AllResultColumn) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public int countReferencedColumns() {
        int n = 0;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            if (resultColumn.isReferenced()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public void recordColumnReferences(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.size();
        int n4 = 0;
        while (n4 < n3) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n4);
            if (resultColumn.isReferenced()) {
                nArray[n2++] = n4 + n;
            }
            ++n4;
        }
    }

    public void recordColumnReferences(boolean[] blArray, JBitSet[] jBitSetArray, int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            if (resultColumn.getExpression() instanceof ColumnReference) {
                int n4 = ((ColumnReference)resultColumn.getExpression()).getColumnNumber();
                blArray[n4] = true;
                jBitSetArray[n].set(n4);
            }
            ++n3;
        }
    }

    int allTopCRsFromSameTable() {
        int n = -1;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)valueNode;
                if (n == -1) {
                    n = columnReference.getTableNumber();
                } else if (n != columnReference.getTableNumber()) {
                    return -1;
                }
            }
            ++n3;
        }
        return n;
    }

    public void clearColumnReferences() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.isReferenced()) {
                resultColumn.setUnreferenced();
            }
            ++n2;
        }
    }

    public void copyReferencedColumnsToNewList(ResultColumnList resultColumnList) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.isReferenced()) {
                resultColumnList.addElement(resultColumn);
            }
            ++n2;
        }
    }

    public void copyColumnsToNewList(ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (formatableBitSet.isSet(resultColumn.getColumnPosition())) {
                resultColumnList.addElement(resultColumn);
            }
            ++n2;
        }
    }

    public FormatableBitSet getColumnReferenceMap() {
        FormatableBitSet formatableBitSet = new FormatableBitSet(this.size());
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.isReferenced()) {
                formatableBitSet.set(n2);
            }
            ++n2;
        }
        return formatableBitSet;
    }

    void pullVirtualIsReferenced() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.pullVirtualIsReferenced();
            ++n2;
        }
    }

    public void clearTableNames() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.clearTableName();
            ++n2;
        }
    }

    protected void setCountMismatchAllowed(boolean bl) {
        this.countMismatchAllowed = bl;
    }

    protected boolean getCountMismatchAllowed() {
        return this.countMismatchAllowed;
    }

    public int getTotalColumnSize() {
        int n = 0;
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            n += ((ResultColumn)this.elementAt(n3)).getMaximumColumnSize();
            ++n3;
        }
        return n;
    }

    public void createListFromResultSetMetaData(ResultSetMetaData resultSetMetaData, TableName tableName, String string) throws StandardException {
        try {
            int n = resultSetMetaData.getColumnCount();
            if (n <= 0) {
                throw StandardException.newException("42X57", string, (Object)String.valueOf(n));
            }
            int n2 = 1;
            while (n2 <= n) {
                TypeId typeId;
                boolean bl = resultSetMetaData.isNullable(n2) != 0;
                int n3 = resultSetMetaData.getColumnType(n2);
                switch (n3) {
                    case 1111: 
                    case 2000: {
                        typeId = TypeId.getUserDefinedTypeId(resultSetMetaData.getColumnTypeName(n2), false);
                        break;
                    }
                    default: {
                        typeId = TypeId.getBuiltInTypeId(n3);
                        break;
                    }
                }
                if (typeId == null) {
                    throw StandardException.newException("42Y23", Integer.toString(n2));
                }
                int n4 = typeId.variableLength() ? resultSetMetaData.getColumnDisplaySize(n2) : (n3 == -1 || n3 == -4 ? Integer.MAX_VALUE : 0);
                int n5 = typeId.isDecimalTypeId() ? resultSetMetaData.getPrecision(n2) : 0;
                int n6 = typeId.isDecimalTypeId() ? resultSetMetaData.getScale(n2) : 0;
                DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, n5, n6, bl, n4);
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, resultSetMetaData.getColumnName(n2), tableName, dataTypeDescriptor, this.getContextManager());
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, resultSetMetaData.getColumnName(n2), valueNode, this.getContextManager());
                resultColumn.setType(dataTypeDescriptor);
                this.addResultColumn(resultColumn);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof StandardException) {
                throw (StandardException)throwable;
            }
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public void addRCForRID() throws StandardException {
        CurrentRowLocationNode currentRowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", currentRowLocationNode, this.getContextManager());
        resultColumn.markGenerated();
        this.addResultColumn(resultColumn);
    }

    public void markAllUnreferenced() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.setUnreferenced();
            ++n2;
        }
    }

    boolean allExpressionsAreColumns(ResultSetNode resultSetNode) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ValueNode valueNode2 = resultColumn.getExpression();
            if (!(valueNode2 instanceof VirtualColumnNode) && !(valueNode2 instanceof ColumnReference)) {
                return false;
            }
            if (valueNode2 instanceof VirtualColumnNode && ((VirtualColumnNode)(valueNode = (VirtualColumnNode)valueNode2)).getSourceResultSet() != resultSetNode) {
                ((VirtualColumnNode)valueNode).setCorrelated();
                return false;
            }
            if (valueNode2 instanceof ColumnReference && ((ColumnReference)(valueNode = (ColumnReference)valueNode2)).getCorrelated()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    int[] mapSourceColumns() {
        int[] nArray = new int[this.size()];
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            nArray[n2] = resultColumn.getExpression() instanceof VirtualColumnNode ? (((VirtualColumnNode)(valueNode = (VirtualColumnNode)resultColumn.getExpression())).getCorrelated() ? -1 : ((VirtualColumnNode)valueNode).getSourceColumn().getVirtualColumnId()) : (resultColumn.getExpression() instanceof ColumnReference ? (((ColumnReference)(valueNode = (ColumnReference)resultColumn.getExpression())).getCorrelated() ? -1 : ((ColumnReference)valueNode).getSource().getVirtualColumnId()) : -1);
            ++n2;
        }
        return nArray;
    }

    public void setNullability(boolean bl) {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.setNullability(bl);
            ++n2;
        }
    }

    FormatableBitSet getReferencedFormatableBitSet(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        int n2 = this.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        if (bl) {
            if (bl2) {
                int n3 = 0;
                while (n3 < n2) {
                    formatableBitSet.set(n3);
                    ++n3;
                }
                return formatableBitSet;
            }
            return null;
        }
        int n4 = 0;
        while (n4 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n4);
            if (resultColumn.isReferenced() && (!bl3 || resultColumn.getExpression() instanceof BaseColumnNode)) {
                formatableBitSet.set(n4);
                ++n;
            }
            ++n4;
        }
        if (n != n4 || bl2) {
            return formatableBitSet;
        }
        return null;
    }

    ResultColumnList compactColumns(boolean bl, boolean bl2) throws StandardException {
        int n = 0;
        if (bl) {
            return this;
        }
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n3);
            if (resultColumn.isReferenced()) {
                resultColumnList.addResultColumn(resultColumn);
                ++n;
            }
            ++n3;
        }
        if (n != n3 || bl2) {
            return resultColumnList;
        }
        return this;
    }

    void removeJoinColumns(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            if (resultColumn2 != null) {
                this.removeElement(resultColumn2);
            }
            ++n2;
        }
    }

    ResultColumnList getJoinColumns(ResultColumnList resultColumnList) {
        ResultColumnList resultColumnList2 = new ResultColumnList();
        int n = resultColumnList.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(n2);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            resultColumnList2.addElement(resultColumn2);
            ++n2;
        }
        return resultColumnList2;
    }

    void resetVirtualColumnIds() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ((ResultColumn)this.elementAt(n2)).setVirtualColumnId(n2 + 1);
            ++n2;
        }
    }

    boolean reusableResult() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!(resultColumn.getExpression() instanceof ConstantNode) && !(resultColumn.getExpression() instanceof AggregateNode)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int[] getColumnPositions(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            String string = resultColumn.getName();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", string, (Object)tableDescriptor.getQualifiedName());
            }
            nArray[n2] = columnDescriptor.getPosition();
            ++n2;
        }
        return nArray;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.size()];
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            stringArray[n2] = resultColumn.getName();
            ++n2;
        }
        return stringArray;
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (resultColumn.isDefaultColumn()) {
                Object object;
                ColumnDescriptor columnDescriptor;
                if (resultColumnList == null) {
                    columnDescriptor = tableDescriptor.getColumnDescriptor(n2 + 1);
                } else {
                    object = (ResultColumn)resultColumnList.elementAt(n2);
                    columnDescriptor = tableDescriptor.getColumnDescriptor(((ResultColumn)object).getName());
                }
                if (columnDescriptor == null) {
                    throw StandardException.newException("42X06", tableDescriptor.getQualifiedName());
                }
                if (columnDescriptor.isAutoincrement()) {
                    resultColumn.setAutoincrementGenerated();
                }
                if ((object = (DefaultInfoImpl)columnDescriptor.getDefaultInfo()) != null) {
                    DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(this.getDataDictionary());
                    this.getCompilerContext().createDependency(defaultDescriptor);
                    resultColumn.setExpression(DefaultNode.parseDefault(((DefaultInfoImpl)object).getDefaultText(), this.getLanguageConnectionContext(), this.getCompilerContext()));
                } else {
                    resultColumn.setExpression((ValueNode)this.getNodeFactory().getNode(13, this.getContextManager()));
                }
                resultColumn.setDefaultColumn(false);
            }
            ++n2;
        }
    }

    void checkForInvalidDefaults() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!resultColumn.isAutoincrementGenerated() && resultColumn.isDefaultColumn()) {
                throw StandardException.newException("42Y85");
            }
            ++n2;
        }
    }

    void verifyAllOrderable() throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            resultColumn.verifyOrderable();
            ++n2;
        }
    }

    public void populate(TableDescriptor tableDescriptor, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        TableName tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            String string = tableDescriptor.getColumnDescriptor(n3).getColumnName();
            ResultColumn resultColumn = this.makeColumnFromName(string);
            this.addResultColumn(resultColumn);
            ++n2;
        }
    }

    private ResultColumn makeColumnFromName(String string) throws StandardException {
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, null, this.getContextManager());
        return resultColumn;
    }

    private ResultColumn makeColumnReferenceFromName(TableName tableName, String string) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, null, nodeFactory.getNode(62, string, tableName, contextManager), contextManager);
        return resultColumn;
    }

    public void checkAutoincrement(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            ResultColumn resultColumn2 = (ResultColumn)(resultColumnList == null ? null : resultColumnList.elementAt(n2));
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            if (columnDescriptor != null && columnDescriptor.isAutoincrement()) {
                if (resultColumn2 != null && resultColumn2.isAutoincrementGenerated()) {
                    resultColumn2.setColumnDescriptor(columnDescriptor.getTableDescriptor(), columnDescriptor);
                } else {
                    throw StandardException.newException("42Z23", resultColumn.getName());
                }
            }
            ++n2;
        }
    }

    public void incOrderBySelect() {
        ++this.orderBySelect;
    }

    public void decOrderBySelect() {
        --this.orderBySelect;
    }

    public int getOrderBySelect() {
        return this.orderBySelect;
    }
}

