/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropAliasConstantAction
extends DDLConstantAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private SchemaDescriptor sd;
    private final String schemaName;
    private final String aliasName;
    private final char nameSpace;

    public String toString() {
        return "DROP ALIAS " + this.aliasName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        AliasDescriptor aliasDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.sd == null) {
            this.sd = dataDictionary.getSchemaDescriptor(this.schemaName, languageConnectionContext.getTransactionExecute(), true);
        }
        if ((aliasDescriptor = dataDictionary.getAliasDescriptor(this.sd.getUUID().toString(), this.aliasName, this.nameSpace)) == null) {
            throw StandardException.newException("42X94", "Method alias", (Object)this.aliasName);
        }
        int n = 0;
        switch (aliasDescriptor.getAliasType()) {
            case 'F': 
            case 'P': {
                n = 6;
                break;
            }
        }
        dependencyManager.invalidateFor(aliasDescriptor, n, languageConnectionContext);
        dataDictionary.dropAliasDescriptor(aliasDescriptor, languageConnectionContext.getTransactionExecute());
    }

    DropAliasConstantAction(SchemaDescriptor schemaDescriptor, String string, char c) {
        this.sd = schemaDescriptor;
        this.schemaName = schemaDescriptor.getSchemaName();
        this.aliasName = string;
        this.nameSpace = c;
    }
}

