/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;

public class NestedLoopLeftOuterJoinResultSet
extends NestedLoopJoinResultSet {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected GeneratedMethod emptyRowFun;
    private boolean wasRightOuterJoin;
    private boolean matchRight = false;
    private boolean returnedEmptyRight = false;
    private ExecRow rightEmptyRow = null;
    public int emptyRightRowsReturned = 0;

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        boolean bl = false;
        boolean bl2 = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (this.returnedEmptyRight) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
            this.returnedEmptyRight = false;
        }
        while (this.leftRow != null && !bl) {
            this.rightRow = this.rightResultSet.getNextRowCore();
            if (this.rightRow == null) {
                if (!this.matchRight) {
                    bl = true;
                    this.returnedEmptyRight = true;
                    if (this.rightEmptyRow == null) {
                        this.rightEmptyRow = (ExecRow)this.emptyRowFun.invoke(this.activation);
                    }
                    this.getMergedRow(this.leftRow, this.rightEmptyRow);
                    ++this.emptyRightRowsReturned;
                    continue;
                }
                this.matchRight = false;
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl3 = bl2 = !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
                if (!bl2) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            this.matchRight = true;
            this.getMergedRow(this.leftRow, this.rightRow);
            bl = true;
        }
        if (bl) {
            execRow = this.mergedRow;
            this.setCurrentRow(this.mergedRow);
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    protected void getMergedRow(ExecRow execRow, ExecRow execRow2) throws StandardException {
        int n;
        int n2;
        if (this.wasRightOuterJoin) {
            ExecRow execRow3 = execRow;
            execRow = execRow2;
            execRow2 = execRow3;
            n2 = this.rightNumCols;
            n = this.leftNumCols;
        } else {
            n2 = this.leftNumCols;
            n = this.rightNumCols;
        }
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(n2 + n);
        }
        int n3 = 1;
        int n4 = 1;
        while (n3 <= n2) {
            this.mergedRow.setColumn(n4, execRow.getColumn(n3));
            ++n3;
            ++n4;
        }
        n3 = 1;
        while (n3 <= n) {
            this.mergedRow.setColumn(n4, execRow2.getColumn(n3));
            ++n3;
            ++n4;
        }
    }

    void clearScanState() {
        this.matchRight = false;
        this.returnedEmptyRight = false;
        this.rightEmptyRow = null;
        this.emptyRightRowsReturned = 0;
        super.clearScanState();
    }

    public NestedLoopLeftOuterJoinResultSet(NoPutResultSet noPutResultSet, int n, NoPutResultSet noPutResultSet2, int n2, Activation activation, GeneratedMethod generatedMethod, int n3, GeneratedMethod generatedMethod2, boolean bl, boolean bl2, boolean bl3, double d, double d2, GeneratedMethod generatedMethod3) {
        super(noPutResultSet, n, noPutResultSet2, n2, activation, generatedMethod, n3, bl2, bl3, d, d2, generatedMethod3);
        this.emptyRowFun = generatedMethod2;
        this.wasRightOuterJoin = bl;
    }
}

