/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.impl.store.access.btree.BTreeScan;

class BTreeScanInfo
implements ScanInfo {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private int stat_numpages_visited = 0;
    private int stat_numrows_visited = 0;
    private int stat_numrows_qualified = 0;
    private int stat_numdeleted_rows_visited = 0;
    private int stat_numColumnsFetched = 0;
    private int stat_treeHeight = 0;
    private FormatableBitSet stat_validColumns = null;

    public Properties getAllScanInfo(Properties properties) throws StandardException {
        if (properties == null) {
            properties = new Properties();
        }
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ0.U"), MessageService.getTextMessage("XSAJF.U"));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ1.U"), Integer.toString(this.stat_numpages_visited));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ2.U"), Integer.toString(this.stat_numrows_visited));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ3.U"), Integer.toString(this.stat_numdeleted_rows_visited));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ4.U"), Integer.toString(this.stat_numrows_qualified));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ7.U"), Integer.toString(this.stat_treeHeight));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ5.U"), Integer.toString(this.stat_numColumnsFetched));
        ((Hashtable)properties).put(MessageService.getTextMessage("XSAJ6.U"), this.stat_validColumns == null ? MessageService.getTextMessage("XSAJE.U") : this.stat_validColumns.toString());
        return properties;
    }

    BTreeScanInfo(BTreeScan bTreeScan) {
        this.stat_numpages_visited = bTreeScan.stat_numpages_visited;
        this.stat_numrows_visited = bTreeScan.stat_numrows_visited;
        this.stat_numrows_qualified = bTreeScan.stat_numrows_qualified;
        this.stat_numdeleted_rows_visited = bTreeScan.stat_numdeleted_rows_visited;
        FormatableBitSet formatableBitSet = this.stat_validColumns = bTreeScan.init_scanColumnList == null ? null : (FormatableBitSet)bTreeScan.init_scanColumnList.clone();
        if (this.stat_validColumns == null) {
            this.stat_numColumnsFetched = bTreeScan.init_template.length;
        } else {
            int n = 0;
            while (n < this.stat_validColumns.size()) {
                if (this.stat_validColumns.get(n)) {
                    ++this.stat_numColumnsFetched;
                }
                ++n;
            }
        }
        try {
            this.stat_treeHeight = bTreeScan.getHeight();
        }
        catch (Throwable throwable) {
            this.stat_treeHeight = -1;
        }
    }
}

