/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.TruncationPoint;

public class CheckpointOperation
implements Loggable {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    protected long redoLWM;
    protected long undoLWM;
    protected TruncationPoint[] truncationLWM;
    protected Formatable transactionTable;

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.redoLWM);
        CompressedNumber.writeLong(objectOutput, this.undoLWM);
        if (this.truncationLWM == null) {
            CompressedNumber.writeInt(objectOutput, 0);
        } else {
            CompressedNumber.writeInt(objectOutput, this.truncationLWM.length);
            int n = 0;
            while (n < this.truncationLWM.length) {
                objectOutput.writeObject(this.truncationLWM[n].getName());
                LogCounter logCounter = (LogCounter)this.truncationLWM[n].getLogInstant();
                CompressedNumber.writeLong(objectOutput, logCounter.getValueAsLong());
                ++n;
            }
        }
        if (this.transactionTable == null) {
            CompressedNumber.writeInt(objectOutput, 0);
        } else {
            CompressedNumber.writeInt(objectOutput, 1);
            objectOutput.writeObject(this.transactionTable);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.redoLWM = CompressedNumber.readLong(objectInput);
        this.undoLWM = CompressedNumber.readLong(objectInput);
        int n = CompressedNumber.readInt(objectInput);
        if (n == 0) {
            this.truncationLWM = null;
        } else {
            this.truncationLWM = new TruncationPoint[n];
            int n2 = 0;
            while (n2 < n) {
                UUID uUID = (UUID)objectInput.readObject();
                long l = CompressedNumber.readLong(objectInput);
                this.truncationLWM[n2] = new TruncationPoint(uUID, new LogCounter(l));
                ++n2;
            }
        }
        int n3 = CompressedNumber.readInt(objectInput);
        this.transactionTable = n3 == 1 ? (Formatable)objectInput.readObject() : null;
    }

    public int getTypeFormatId() {
        return 263;
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException {
        if (((RawTransaction)transaction).inRollForwardRecovery()) {
            ((RawTransaction)transaction).checkpointInRollForwardRecovery(logInstant, this.redoLWM);
        }
    }

    public ByteArray getPreparedLog() {
        return null;
    }

    public boolean needsRedo(Transaction transaction) {
        return ((RawTransaction)transaction).inRollForwardRecovery();
    }

    public void releaseResource(Transaction transaction) {
    }

    public int group() {
        return 256;
    }

    public long redoLWM() {
        return this.redoLWM;
    }

    public long undoLWM() {
        return this.undoLWM;
    }

    public TruncationPoint[] truncationLWM() {
        return this.truncationLWM;
    }

    public Formatable getTransactionTable() {
        return this.transactionTable;
    }

    public String toString() {
        return null;
    }

    public CheckpointOperation(long l, long l2, TruncationPoint[] truncationPointArray, Formatable formatable) {
        this.redoLWM = l;
        this.undoLWM = l2;
        this.truncationLWM = truncationPointArray;
        this.transactionTable = formatable;
    }

    public CheckpointOperation() {
    }
}

