/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.impl.tools.ij.ijException;

public class StatementFinder {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final int IN_STATEMENT = 0;
    private static final int IN_STRING = 1;
    private static final int IN_SQLCOMMENT = 2;
    private static final int END_OF_STATEMENT = 3;
    private static final int END_OF_INPUT = 4;
    private static final char MINUS = '-';
    private static final char SINGLEQUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char FORMFEED = '\f';
    private Reader source;
    private StringBuffer statement = new StringBuffer();
    private int state;
    private boolean atEOF = false;
    private boolean peekEOF = false;
    private char peekChar;
    private boolean peeked = false;

    public void ReInit(Reader reader) {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.source = reader;
        this.state = 0;
        this.atEOF = false;
        this.peekEOF = false;
        this.peeked = false;
    }

    public void close() throws IOException {
        this.source.close();
    }

    /*
     * Unable to fully structure code
     */
    public String nextStatement() {
        var1_1 = false;
        this.statement.setLength(0);
        if (this.state == 4) {
            return null;
        }
        this.state = 0;
        var2_2 = this.peekChar();
        if (this.peekEOF()) {
            this.state = 4;
            return null;
        }
        if (!this.whiteSpace(var2_2)) ** GOTO lbl33
        while (this.whiteSpace(this.peekChar()) && !this.peekEOF()) {
        }
        if (!this.peekEOF()) ** GOTO lbl33
        this.state = 4;
        return null;
lbl-1000:
        // 1 sources

        {
            var2_2 = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                break;
            }
            switch (var2_2) {
                case '-': {
                    this.readSingleLineComment(var2_2);
                    break;
                }
                case '\"': 
                case '\'': {
                    this.readString(var2_2);
                    break;
                }
                case ';': {
                    var1_1 = true;
                    this.state = 3;
                    break;
                }
                default: {
                    break;
                }
            }
lbl33:
            // 6 sources

            ** while (this.state != 3 && this.state != 4)
        }
lbl34:
        // 2 sources

        if (var1_1) {
            this.statement.setLength(this.statement.length() - 1);
        }
        return this.statement.toString();
    }

    private boolean whiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private void readSingleLineComment(char c) {
        char c2 = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (c2 != c) {
            return;
        }
        this.readChar();
        this.state = 2;
        do {
            c2 = this.peekChar();
            if (this.peekEOF()) {
                this.state = 0;
                return;
            }
            switch (c2) {
                case '\n': 
                case '\r': {
                    this.readChar();
                    this.state = 0;
                    return;
                }
            }
            this.readChar();
        } while (this.state == 2);
    }

    private void readString(char c) {
        this.state = 1;
        do {
            char c2 = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                return;
            }
            if (c2 != c) continue;
            this.state = 0;
            return;
        } while (this.state == 1);
    }

    private boolean atEOF() {
        return this.atEOF;
    }

    private boolean peekEOF() {
        return this.peekEOF;
    }

    private char readChar() {
        if (!this.peeked) {
            this.peekChar();
        }
        this.peeked = false;
        this.atEOF = this.peekEOF;
        if (!this.atEOF) {
            this.statement.append(this.peekChar);
        }
        return this.peekChar;
    }

    private char peekChar() {
        this.peeked = true;
        char c = '\u0000';
        try {
            int n = this.source.read();
            boolean bl = this.peekEOF = n == -1;
            if (!this.peekEOF) {
                c = (char)n;
            }
        }
        catch (IOException iOException) {
            throw ijException.iOException(iOException);
        }
        this.peekChar = c;
        return c;
    }

    public StatementFinder(Reader reader) {
        this.source = reader;
    }
}

