/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.BufferedReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.cslook.DB_Check;
import org.apache.derby.impl.tools.cslook.DB_Index;
import org.apache.derby.impl.tools.cslook.DB_Jar;
import org.apache.derby.impl.tools.cslook.DB_Key;
import org.apache.derby.impl.tools.cslook.DB_Schema;
import org.apache.derby.impl.tools.cslook.DB_StoredProcedure;
import org.apache.derby.impl.tools.cslook.DB_Table;
import org.apache.derby.impl.tools.cslook.DB_Trigger;
import org.apache.derby.impl.tools.cslook.DB_View;
import org.apache.derby.impl.tools.cslook.Logs;

public class dblook {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";
    public static final int DB2_MAX_NUMBER_OF_TABLES = 30;
    private static PreparedStatement getColNameFromNumberQuery;
    protected static HashMap schemaMap;
    protected static HashMap tableIdToNameMap;
    protected static String sourceDBUrl;
    protected static String ddlFileName;
    protected static String stmtDelimiter;
    protected static boolean appendLogs;
    protected static ArrayList tableList;
    protected static String schemaParam;
    protected static String targetSchema;
    protected static boolean skipViews;
    protected static boolean verbose;
    private static String sourceDBName;
    private static String lookLogName;
    private static final String DEFAULT_LOCALE = "en";
    private static final String DEFAULT_LOCALE_COUNTRY = "US";
    private static LocalizedResource langUtil;
    public static final String[] ignorableSchemaNames;
    private Connection conn;

    public static void main(String[] stringArray) {
        dblook dblook2 = new dblook(stringArray);
        try {
            dblook2.go(sourceDBUrl, sourceDBName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initState() {
        sourceDBUrl = null;
        ddlFileName = null;
        stmtDelimiter = null;
        appendLogs = false;
        tableList = null;
        targetSchema = null;
        schemaParam = null;
        skipViews = false;
        verbose = false;
        sourceDBName = null;
    }

    private boolean parseArgs(String[] stringArray) {
        if (stringArray.length < 2) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (bl2 < stringArray.length) {
            bl = this.loadParam(stringArray, bl2 ? 1 : 0);
            if (bl) {
                return false;
            }
            bl2 = bl;
            bl2 += 1;
        }
        if (sourceDBUrl == null) {
            return false;
        }
        bl2 = Logs.initLogs(lookLogName, ddlFileName, appendLogs, verbose, stmtDelimiter == null ? ";" : stmtDelimiter);
        sourceDBName = this.extractDBNameFromUrl(sourceDBUrl);
        targetSchema = schemaParam != null && schemaParam.length() > 0 && schemaParam.charAt(0) != '\"' ? dblook.addQuotes(dblook.expandDoubleQuotes(schemaParam.toUpperCase(Locale.ENGLISH))) : dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(schemaParam)));
        return bl2;
    }

    private int loadParam(String[] stringArray, int n) {
        if (stringArray[n].length() == 0 || stringArray[n].charAt(0) != '-') {
            return n;
        }
        boolean bl = stringArray.length > n + 1;
        switch (stringArray[n].charAt(1)) {
            case 'd': {
                if (!bl) {
                    return -1;
                }
                if (stringArray[n].length() == 2) {
                    sourceDBUrl = stringArray[++n];
                }
                return n;
            }
            case 'z': {
                if (!bl) {
                    return -1;
                }
                if (stringArray[n].length() == 2) {
                    schemaParam = stringArray[++n];
                }
                return n;
            }
            case 't': {
                if (!bl) {
                    return -1;
                }
                if (stringArray[n].equals("-td")) {
                    stmtDelimiter = stringArray[++n];
                    return n;
                }
                if (stringArray[n].equals("-t")) {
                    return this.extractTableNamesFromList(stringArray, n + 1);
                }
                return -1;
            }
            case 'o': {
                if (!bl) {
                    return -1;
                }
                if (stringArray[n].length() == 2 && stringArray[n + 1].length() > 0) {
                    ddlFileName = stringArray[++n];
                }
                return n;
            }
            case 'a': {
                if (stringArray[n].equals("-append")) {
                    appendLogs = true;
                    return n;
                }
                return -1;
            }
            case 'n': {
                if (stringArray[n].equals("-noview")) {
                    skipViews = true;
                    return n;
                }
                return -1;
            }
            case 'v': {
                if (stringArray[n].equals("-verbose")) {
                    verbose = true;
                    return n;
                }
                return -1;
            }
        }
        return -1;
    }

    private boolean loadDriver() {
        String string = sourceDBUrl.indexOf(":net://") != -1 ? "com.ibm.db2.jcc.DB2Driver" : "org.apache.derby.jdbc.EmbeddedDriver";
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            Logs.debug(exception);
            return false;
        }
        return true;
    }

    protected String extractDBNameFromUrl(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf("jdbc:derby:");
        if (n == -1) {
            return "";
        }
        n = string.indexOf("net://");
        n = n == -1 ? string.indexOf("cloudscape:") + 11 : string.indexOf("/", n + 6) + 1;
        int n2 = -1;
        if (string.charAt(n) == '\"') {
            n2 = string.indexOf("\"", ++n);
        } else {
            n2 = string.indexOf(":", n);
            if (n2 != -1 && (string.charAt(n2 + 1) == '/' || string.charAt(n2 + 1) == '\\')) {
                n2 = string.indexOf(":", n2 + 2);
            }
            int n3 = string.length();
            if (n2 == -1) {
                n2 = string.indexOf(";", n);
            } else {
                n3 = string.indexOf(";", n);
            }
            int n4 = n2 = n2 <= n3 ? n2 : n3;
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    private int extractTableNamesFromList(String[] stringArray, int n) {
        int n2 = n;
        int n3 = 0;
        tableList = new ArrayList();
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() > 0 && stringArray[n2].charAt(0) == '-' || ++n3 > 30) break;
            if (stringArray[n2].length() > 0 && stringArray[n2].charAt(0) == '\"') {
                tableList.add(dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(stringArray[n2++]))));
                continue;
            }
            tableList.add(dblook.addQuotes(dblook.expandDoubleQuotes(stringArray[n2++].toUpperCase(Locale.ENGLISH))));
        }
        if (tableList.size() == 0) {
            tableList = null;
        }
        return n2 - 1;
    }

    private void showVariables() {
        if (ddlFileName != null) {
            Logs.reportString("============================\n");
            Logs.reportMessage("CSLOOK_FileCreation");
            if (verbose) {
                dblook.writeVerboseOutput("CSLOOK_OutputLocation", ddlFileName);
            }
        }
        Logs.reportMessage("CSLOOK_Timestamp", new Timestamp(System.currentTimeMillis()).toString());
        Logs.reportMessage("CSLOOK_DBName", sourceDBName);
        Logs.reportMessage("CSLOOK_DBUrl", sourceDBUrl);
        if (tableList != null) {
            Logs.reportMessage("CSLOOK_TargetTables");
        }
        if (schemaParam != null) {
            Logs.reportMessage("CSLOOK_TargetSchema", dblook.stripQuotes(schemaParam));
        }
        Logs.reportString("appendLogs: " + appendLogs + "\n");
    }

    public void go(String string, String string2) throws Exception {
        try {
            try {
                this.conn = DriverManager.getConnection(string);
                try {
                    this.prepForDump();
                }
                catch (SQLException sQLException) {
                    Logs.debug(sQLException);
                    Logs.debug(Logs.unRollExceptions(sQLException), null);
                    Logs.cleanup();
                    Object var4_7 = null;
                    this.conn.commit();
                    this.conn.close();
                    return;
                }
                catch (Exception exception) {
                    Logs.debug(exception);
                    Logs.cleanup();
                    Object var4_8 = null;
                    this.conn.commit();
                    this.conn.close();
                    return;
                }
                DB_Schema.doSchemas(this.conn, tableList != null && targetSchema == null);
                if (tableList == null) {
                    DB_Jar.doJars(string2, this.conn);
                    DB_StoredProcedure.doStoredProcedures(this.conn);
                }
                DB_Table.doTables(this.conn, tableIdToNameMap);
                DB_Index.doIndexes(this.conn);
                DB_Key.doKeys(this.conn);
                DB_Check.doChecks(this.conn);
                if (!skipViews) {
                    DB_View.doViews(this.conn);
                }
                DB_Trigger.doTriggers(this.conn);
                if (getColNameFromNumberQuery != null) {
                    getColNameFromNumberQuery.close();
                }
                Logs.cleanup();
            }
            catch (SQLException sQLException) {
                Logs.debug(sQLException);
                Logs.debug(Logs.unRollExceptions(sQLException), null);
                Logs.cleanup();
                throw sQLException;
            }
            catch (Exception exception) {
                Logs.debug(exception);
                Logs.cleanup();
                throw exception;
            }
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.conn.commit();
            this.conn.close();
            throw throwable;
        }
        this.conn.commit();
        this.conn.close();
    }

    private void prepForDump() throws Exception {
        this.conn.setAutoCommit(false);
        getColNameFromNumberQuery = this.conn.prepareStatement("SELECT COLUMNNAME FROM SYS.SYSCOLUMNS WHERE REFERENCEID = ? AND COLUMNNUMBER = ?");
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT T.TABLEID, T.TABLENAME, S.SCHEMANAME FROM SYS.SYSTABLES T, SYS.SYSSCHEMAS S WHERE T.TABLETYPE = 'T' AND T.SCHEMAID = S.SCHEMAID");
        while (resultSet.next()) {
            String string = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2)));
            String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(3)));
            tableIdToNameMap.put(resultSet.getString(1), string2 + "." + string);
        }
        resultSet = statement.executeQuery("SELECT SCHEMAID, SCHEMANAME FROM SYS.SYSSCHEMAS");
        while (resultSet.next()) {
            schemaMap.put(resultSet.getString(1), dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(2))));
        }
        statement.close();
    }

    public static String getColumnListFromDescription(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(string2.indexOf("(") + 1, string2.lastIndexOf(")")), " ,", true);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("")) continue;
            if (string3.equals(",")) {
                bl = false;
                continue;
            }
            try {
                String string4 = dblook.getColNameFromNumber(string, Integer.valueOf(string3));
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string4);
            }
            catch (NumberFormatException numberFormatException) {
                string3 = string3.toUpperCase();
                if (string3.equals("DESC") || string3.equals("ASC")) {
                    stringBuffer.append(" " + string3);
                    continue;
                }
                Logs.debug("INTERNAL ERROR: read a non-number (" + string3 + ") when a column number was expected:\n" + string2, null);
            }
        }
        return stringBuffer.toString();
    }

    public static String getColNameFromNumber(String string, int n) throws SQLException {
        getColNameFromNumberQuery.setString(1, string);
        getColNameFromNumberQuery.setInt(2, n);
        ResultSet resultSet = getColNameFromNumberQuery.executeQuery();
        if (!resultSet.next()) {
            Logs.debug("INTERNAL ERROR: Failed column number lookup for table " + dblook.lookupTableId(string) + ", column " + n, null);
            resultSet.close();
            return "";
        }
        String string2 = dblook.addQuotes(dblook.expandDoubleQuotes(resultSet.getString(1)));
        resultSet.close();
        return string2;
    }

    public static String addQuotes(String string) {
        if (string == null) {
            return null;
        }
        return "\"" + string + "\"";
    }

    public static String stripQuotes(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("\"") == -1 && string.indexOf("'") == -1) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public static boolean isExcludedTable(String string) {
        if (string == null) {
            return true;
        }
        int n = string.indexOf(".");
        if (n != -1) {
            if (dblook.isIgnorableSchema(string.substring(0, n))) {
                return true;
            }
            string = string.substring(n + 1, string.length());
        }
        return tableList != null && !tableList.contains(string);
    }

    public static boolean isIgnorableSchema(String string) {
        if (targetSchema != null && !string.equals(targetSchema)) {
            return true;
        }
        string = dblook.stripQuotes(string);
        boolean bl = false;
        int n = ignorableSchemaNames.length - 1;
        while (n >= 0) {
            if (bl = ignorableSchemaNames[n--].equalsIgnoreCase(string)) break;
        }
        return bl;
    }

    public static boolean stringContainsTargetTable(String string) {
        if (string == null) {
            return false;
        }
        if (tableList == null) {
            return true;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < tableList.size()) {
            String string2 = (String)tableList.get(n2);
            string2 = dblook.expandDoubleQuotes(dblook.stripQuotes(string2));
            int n3 = string2.length();
            String string3 = string2.equals(string2.toUpperCase(Locale.ENGLISH)) ? string.toUpperCase() : string;
            int n4 = string3.indexOf(string2);
            while (n4 != -1) {
                if (!dblook.partOfWord(string, n4, n3, n)) {
                    if (n4 >= 1 && string3.charAt(n4 - 1) == '\"' && n4 + n3 < string3.length() && string3.charAt(n4 + n3) == '\"') {
                        if (string.substring(n4, n4 + n3).equals(string2)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                n4 = string.indexOf(string2, n4 + n3);
            }
            ++n2;
        }
        return false;
    }

    private static boolean partOfWord(String string, int n, int n2, int n3) {
        char c;
        boolean bl = false;
        if (n > 0) {
            c = string.charAt(n - 1);
            bl = c == '_' || Character.isLetterOrDigit(c);
        }
        c = '\u0000';
        if (n + n2 < n3) {
            char c2 = string.charAt(n + n2);
            c = c2 != '_' && !Character.isLetterOrDigit(c2) ? (char)'\u0000' : '\u0001';
        }
        return bl || c != '\u0000';
    }

    public static String expandDoubleQuotes(String string) {
        if (string == null || string.indexOf("\"") < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[2 * cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\"') {
                cArray2[n++] = 34;
                cArray2[n++] = 34;
            } else {
                cArray2[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    public static String lookupSchemaId(String string) {
        return (String)schemaMap.get(string);
    }

    public static String lookupTableId(String string) {
        return (String)tableIdToNameMap.get(string);
    }

    public static void writeVerboseOutput(String string, String string2) {
        if (string2 == null) {
            System.err.println(dblook.lookupMessage(string));
        } else {
            System.err.println(dblook.lookupMessage(string, new String[]{string2}));
        }
    }

    public static String lookupMessage(String string) {
        return dblook.lookupMessage(string, null);
    }

    public static String lookupMessage(String string, String[] stringArray) {
        String string2 = "";
        if (stringArray == null) {
            string2 = langUtil.getTextMessage(string);
        } else {
            switch (stringArray.length) {
                case 1: {
                    string2 = langUtil.getTextMessage(string, stringArray[0]);
                    break;
                }
                case 2: {
                    string2 = langUtil.getTextMessage(string, stringArray[0], stringArray[1]);
                    break;
                }
            }
        }
        return string2;
    }

    public static String removeNewlines(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string2);
                } else {
                    stringBuffer.append(" ");
                    stringBuffer.append(string2);
                }
                string2 = bufferedReader.readLine();
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public dblook(String[] stringArray) {
        langUtil = LocalizedResource.getInstance();
        this.initState();
        if (!this.parseArgs(stringArray)) {
            System.out.println(dblook.lookupMessage("CSLOOK_Usage"));
            System.exit(1);
        }
        this.showVariables();
        if (!this.loadDriver()) {
            return;
        }
        schemaMap = new HashMap();
        tableIdToNameMap = new HashMap();
    }

    static {
        lookLogName = "dblook.log";
        ignorableSchemaNames = new String[]{"SYSIBM", "SYS", "SYSVISUAL", "SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_ADMIN", "SYSCS_DIAG", "SYSCS_UTIL", "SQLJ"};
    }
}

