/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class GetProcedureColumns
extends VTITemplate {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2000, 2004.";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("COLUMN_NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMN_TYPE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("DATA_TYPE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE_NAME", 12, false, 22), EmbedResultSetMetaData.getResultColumnDescriptor("PRECISION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("LENGTH", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SCALE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("RADIX", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("NULLABLE", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("REMARKS", 12, true, 22), EmbedResultSetMetaData.getResultColumnDescriptor("METHOD_ID", 5, false), EmbedResultSetMetaData.getResultColumnDescriptor("PARAMETER_ID", 5, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);
    private boolean isProcedure;
    private RoutineAliasInfo procedure;
    private int paramCursor = -1;
    private short method_count;
    private short param_number;
    private TypeDescriptor sqlType;

    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    public boolean next() throws SQLException {
        if (++this.paramCursor >= this.procedure.getParameterCount()) {
            return false;
        }
        this.sqlType = this.procedure.getParameterTypes()[this.paramCursor];
        this.param_number = (short)this.paramCursor;
        return true;
    }

    public String getString(int n) throws SQLException {
        switch (n) {
            case 1: {
                return this.procedure.getParameterNames()[this.paramCursor];
            }
            case 4: {
                return this.sqlType.getTypeName();
            }
            case 10: {
                return null;
            }
        }
        return super.getString(n);
    }

    public int getInt(int n) throws SQLException {
        switch (n) {
            case 5: {
                if (this.sqlType != null) {
                    int n2 = this.sqlType.getJDBCTypeId();
                    if (DataTypeDescriptor.isNumericType(n2)) {
                        return this.sqlType.getPrecision();
                    }
                    if (n2 == 91 || n2 == 92 || n2 == 93) {
                        return DataTypeUtilities.getColumnDisplaySize(n2, -1);
                    }
                    return this.sqlType.getMaximumWidth();
                }
                return 0;
            }
            case 6: {
                if (this.sqlType != null) {
                    return this.sqlType.getMaximumWidth();
                }
                return 0;
            }
        }
        return super.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        switch (n) {
            case 2: {
                return (short)this.procedure.getParameterModes()[this.paramCursor];
            }
            case 3: {
                if (this.sqlType != null) {
                    return (short)this.sqlType.getJDBCTypeId();
                }
                return 2000;
            }
            case 7: {
                if (this.sqlType != null) {
                    return (short)this.sqlType.getScale();
                }
                return 0;
            }
            case 8: {
                if (this.sqlType != null) {
                    int n2 = this.sqlType.getJDBCTypeId();
                    if (n2 == 7 || n2 == 6 || n2 == 8) {
                        return 2;
                    }
                    return 10;
                }
                return 0;
            }
            case 9: {
                return 1;
            }
            case 11: {
                return this.method_count;
            }
            case 12: {
                return this.param_number;
            }
        }
        return super.getShort(n);
    }

    public void close() {
    }

    public GetProcedureColumns(AliasInfo aliasInfo, String string) throws SQLException {
        if (aliasInfo != null) {
            this.isProcedure = string.equals("P");
            this.procedure = (RoutineAliasInfo)aliasInfo;
            this.method_count = (short)this.procedure.getParameterCount();
        }
    }
}

