/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public final class PropertyInfo {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";

    public static Properties getTableProperties(String string, String string2) throws SQLException {
        return PropertyInfo.getConglomerateProperties(string, string2, false);
    }

    public static Properties getIndexProperties(String string, String string2) throws SQLException {
        return PropertyInfo.getConglomerateProperties(string, string2, true);
    }

    public static String getDatabaseProperty(String string) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(languageConnectionContext.getTransactionExecute(), string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public static void setDatabaseProperty(String string, String string2) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        try {
            Authorizer authorizer = languageConnectionContext.getAuthorizer();
            authorizer.authorize(5);
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            transactionController.setProperty(string, (Serializable)((Object)string2), false);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private static Properties getConglomerateProperties(String string, String string2, boolean bl) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            long l;
            Object object;
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
            if (!bl) {
                object = dataDictionary.getTableDescriptor(string2, schemaDescriptor);
                if (object == null || ((TableDescriptor)object).getTableType() == 2) {
                    return new Properties();
                }
                l = ((TableDescriptor)object).getHeapConglomerateId();
            } else {
                object = dataDictionary.getConglomerateDescriptor(string2, schemaDescriptor, false);
                if (object == null) {
                    return new Properties();
                }
                l = ((ConglomerateDescriptor)object).getConglomerateNumber();
            }
            object = transactionController.openConglomerate(l, false, 0, 6, 5);
            Properties properties = transactionController.getUserCreateConglomPropList();
            object.getTableProperties(properties);
            object.close();
            return properties;
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    private PropertyInfo() {
    }
}

