/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.impl.jdbc.authentication.LDAPAuthenticationSchemeImpl;

public class JNDIAuthenticationService
extends AuthenticationServiceBase {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    private String authenticationProvider;

    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        this.authenticationProvider = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return this.authenticationProvider != null && StringUtil.SQLEqualsIgnoreCase(this.authenticationProvider, "LDAP");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        LDAPAuthenticationSchemeImpl lDAPAuthenticationSchemeImpl = new LDAPAuthenticationSchemeImpl(this, properties);
        this.setAuthenticationService(lDAPAuthenticationSchemeImpl);
    }
}

