/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ExportWriteData;
import org.apache.derby.impl.load.ExportWriteDataAbstract;
import org.apache.derby.impl.load.LoadError;

public class Export
extends ExportAbstract {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private String outputFileName;

    private void doExport() throws SQLException {
        try {
            if (this.entityName == null && this.selectStatement == null) {
                throw LoadError.entityNameMissing();
            }
            if (this.outputFileName == null) {
                throw LoadError.dataFileNull();
            }
            try {
                this.doAllTheWork();
            }
            catch (IOException iOException) {
                throw LoadError.errorWritingData();
            }
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    public static void exportTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Export export = new Export(connection, string, string2, null, string3, string5, string4, string6);
        export.doExport();
    }

    public static void exportQuery(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        Export export = new Export(connection, null, null, string, string2, string4, string3, string5);
        export.doExport();
    }

    protected ExportWriteDataAbstract getExportWriteData() throws Exception {
        return new ExportWriteData(this.outputFileName, this.controlFileReader);
    }

    private Export(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        this.con = connection;
        this.schemaName = string;
        this.entityName = string2;
        this.selectStatement = string3;
        this.outputFileName = string4;
        try {
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(string5, string6, string7);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }
}

