/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CurrentUserNode
extends ValueNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    public static final int USER = 0;
    public static final int CURRENT_USER = 1;
    public static final int SESSION_USER = 2;
    public static final int SYSTEM_USER = 3;
    public static final int SCHEMA = 4;
    public static final int IDENTITY_VAL = 5;
    private int whichType;

    public void init(Object object) {
        this.whichType = (Integer)object;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        String string = null;
        switch (this.whichType) {
            case 0: {
                string = "USER";
                break;
            }
            case 1: {
                string = "CURRENT_USER";
                break;
            }
            case 2: {
                string = "SESSION_USER";
                break;
            }
            case 3: {
                string = "SYSTEM_USER";
                break;
            }
            case 4: {
                string = "CURRENT SCHEMA";
                break;
            }
            case 5: {
                string = "IDENTITY_VAL_LOCAL";
                break;
            }
        }
        if (this.whichType == 4) {
            this.checkReliability(string, 512);
        } else {
            this.checkReliability(string, 64);
        }
        if (this.whichType == 5) {
            this.setType(DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 31, 0, true, 31));
        } else {
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, false, 128));
        }
        return this;
    }

    protected int getOrderableVariantType() {
        return 2;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        if (this.whichType == 5) {
            methodBuilder.callMethod((short)185, null, "getIdentityValue", "java.math.BigDecimal", 0);
        } else if (this.whichType == 4) {
            methodBuilder.callMethod((short)185, null, "getCurrentSchemaName", "java.lang.String", 0);
        } else {
            methodBuilder.callMethod((short)185, null, "getAuthorizationId", "java.lang.String", 0);
        }
        String string = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), localField);
    }

    public String toString() {
        return "";
    }
}

