/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class HasCorrelatedCRsVisitor
implements Visitor {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private boolean hasCorrelatedCRs;

    public Visitable visit(Visitable visitable) {
        if (visitable instanceof ColumnReference) {
            if (((ColumnReference)visitable).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (visitable instanceof VirtualColumnNode) {
            if (((VirtualColumnNode)visitable).getCorrelated()) {
                this.hasCorrelatedCRs = true;
            }
        } else if (visitable instanceof MethodCallNode && (((MethodCallNode)visitable).getMethodName().equals("getTriggerExecutionContext") || ((MethodCallNode)visitable).getMethodName().equals("TriggerOldTransitionRows") || ((MethodCallNode)visitable).getMethodName().equals("TriggerNewTransitionRows"))) {
            this.hasCorrelatedCRs = true;
        }
        return visitable;
    }

    public boolean stopTraversal() {
        return this.hasCorrelatedCRs;
    }

    public boolean skipChildren(Visitable visitable) {
        return false;
    }

    public boolean hasCorrelatedCRs() {
        return this.hasCorrelatedCRs;
    }

    public void setHasCorrelatedCRs(boolean bl) {
        this.hasCorrelatedCRs = bl;
    }
}

