/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ParameterNode
extends ValueNode {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    int parameterNumber;
    private boolean generated;
    DataTypeDescriptor[] typeServices;
    DataValueDescriptor defaultValue;
    protected JSQLType jsqlType;
    private int orderableVariantType = 2;
    private ValueNode returnOutputParameter;

    public void init(Object object, Object object2) {
        this.defaultValue = (DataValueDescriptor)object2;
        this.parameterNumber = (Integer)object;
    }

    public int getParameterNumber() {
        return this.parameterNumber;
    }

    public void setDescriptors(DataTypeDescriptor[] dataTypeDescriptorArray) {
        this.typeServices = dataTypeDescriptorArray;
    }

    public void setDescriptor(DataTypeDescriptor dataTypeDescriptor) {
        if (this.typeServices[this.parameterNumber] != null) {
            return;
        }
        if (!dataTypeDescriptor.isNullable()) {
            dataTypeDescriptor = new DataTypeDescriptor(dataTypeDescriptor, true);
        }
        this.typeServices[this.parameterNumber] = dataTypeDescriptor;
        this.setType(dataTypeDescriptor);
        if (this.getJSQLType() == null) {
            this.setJSQLType(new JSQLType(dataTypeDescriptor));
        }
    }

    public void setReturnOutputParam(ValueNode valueNode) {
        this.returnOutputParameter = valueNode;
    }

    public boolean isReturnOutputParam() {
        return this.returnOutputParameter != null;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.checkReliability("?", 8);
        return this;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return true;
    }

    protected int getOrderableVariantType() {
        return this.orderableVariantType;
    }

    void setOrderableVariantType(int n) {
        this.orderableVariantType = n;
    }

    public void setJSQLType(JSQLType jSQLType) {
        this.jsqlType = jSQLType;
    }

    public JSQLType getJSQLType() {
        return this.jsqlType;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateHolder(expressionClassBuilder);
        expressionClassBuilder.pushPVSReference(methodBuilder);
        methodBuilder.push(this.parameterNumber);
        methodBuilder.callMethod((short)185, null, "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        switch (dataTypeDescriptor.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                methodBuilder.dup();
                methodBuilder.push(dataTypeDescriptor.getMaximumWidth());
                methodBuilder.callMethod((short)185, null, "checkHostVariable", "void", 1);
                break;
            }
        }
        methodBuilder.cast(this.getTypeCompiler().interfaceName());
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        if (this.generated) {
            return;
        }
        this.generated = true;
        expressionClassBuilder.pushPVSReference(methodBuilder);
        expressionClassBuilder.generateNull(methodBuilder, this.getTypeCompiler());
        methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.push(this.parameterNumber);
        TypeId typeId = this.getTypeId();
        methodBuilder.push(typeId.getJDBCTypeId());
        methodBuilder.push(typeId.getCorrespondingJavaTypeName());
        methodBuilder.callMethod((short)185, null, "setStorableDataValue", "void", 4);
    }

    public TypeId getTypeId() {
        return this.returnOutputParameter != null ? this.returnOutputParameter.getTypeId() : super.getTypeId();
    }

    public static void generateParameterValueSet(ExpressionClassBuilder expressionClassBuilder, int n, Vector vector) throws StandardException {
        if (n > 0) {
            MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
            boolean bl = ((ParameterNode)vector.elementAt(0)).isReturnOutputParam();
            methodBuilder.pushThis();
            methodBuilder.push(n);
            methodBuilder.push(bl);
            methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "setParameterValueSet", "void", 2);
            MethodBuilder methodBuilder2 = expressionClassBuilder.getExecuteMethod();
            methodBuilder2.pushThis();
            methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "throwIfMissingParms", "void", 0);
        }
    }

    public static void generateParameterHolders(ExpressionClassBuilder expressionClassBuilder, Vector vector) throws StandardException {
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((ParameterNode)enumeration.nextElement()).generateHolder(expressionClassBuilder);
        }
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isParameterNode() {
        return true;
    }
}

